/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public final class ActionUtility {
    public static IActionFilter FALSE_FILTER = new IActionFilter(){

        @Override
        public boolean accept(IAction action) {
            return false;
        }
    };
    public static IActionFilter TRUE_FILTER = new IActionFilter(){

        @Override
        public boolean accept(IAction action) {
            return true;
        }
    };

    private ActionUtility() {
    }

    public static <T extends IAction> List<T> visibleNormalizedActions(List<T> actionNodes) {
        return ActionUtility.normalizedActions(actionNodes, ActionUtility.createVisibleFilter());
    }

    public static <T extends IAction> List<T> normalizedActions(List<T> actionNodes, IActionFilter filter) {
        if (actionNodes == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<T> cleanedActions = ActionUtility.getActions(actionNodes, filter);
        ActionUtility.normalizeSeparators(cleanedActions);
        return cleanedActions;
    }

    public static <T extends IAction> void normalizeSeparators(List<T> actions) {
        IAction prevSeparator = null;
        IAction prevAction = null;
        ListIterator<T> it = actions.listIterator();
        while (it.hasNext()) {
            IAction actionNode = (IAction)it.next();
            if (actionNode.isSeparator()) {
                if (prevAction == null || prevSeparator != null) {
                    it.remove();
                }
                prevAction = null;
                prevSeparator = actionNode;
                continue;
            }
            prevSeparator = null;
            prevAction = actionNode;
        }
        while (it.hasPrevious()) {
            IAction previous = (IAction)it.previous();
            if (!previous.isSeparator()) break;
            it.remove();
        }
    }

    public static <T extends IAction> List<T> getActions(List<T> actions, IActionFilter filter) {
        if (actions != null) {
            ArrayList<IAction> result = new ArrayList<IAction>(actions.size());
            for (IAction a : actions) {
                if (a.isSeparator()) {
                    result.add(a);
                    continue;
                }
                if (!filter.accept(a)) continue;
                result.add(a);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static void initActions(List<? extends IAction> actions) throws ProcessingException {
        InitActionVisitor v = new InitActionVisitor();
        for (IAction iAction : actions) {
            iAction.acceptVisitor(v);
        }
        v.handleResult();
    }

    public static IActionFilter createVisibleFilter() {
        return new IActionFilter(){

            @Override
            public boolean accept(IAction action) {
                if (action.isVisible()) {
                    if (action instanceof IActionNode && ((IActionNode)action).hasChildActions()) {
                        List visibleChildActions = ActionUtility.getActions(((IActionNode)action).getChildActions(), this);
                        return !visibleChildActions.isEmpty();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static IActionFilter createMenuFilterMenuTypes(boolean visibleOnly, IMenuType ... menuTypes) {
        return ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object[])menuTypes), visibleOnly);
    }

    public static IActionFilter createMenuFilterMenuTypes(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
        return new MenuTypeFilter(menuTypes, visibleOnly);
    }

    public static IActionFilter createCombinedFilter(final IActionFilter ... actionFilters) {
        if (actionFilters != null) {
            return new IActionFilter(){

                @Override
                public boolean accept(IAction action) {
                    IActionFilter[] iActionFilterArray = actionFilters;
                    int n = actionFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IActionFilter f = iActionFilterArray[n2];
                        if (!f.accept(action)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
            };
        }
        return TRUE_FILTER;
    }

    private static class InitActionVisitor
    implements IActionVisitor {
        private ProcessingException m_firstEx;

        private InitActionVisitor() {
        }

        @Override
        public int visit(IAction action) {
            block4: {
                try {
                    action.initAction();
                }
                catch (ProcessingException e) {
                    if (this.m_firstEx == null) {
                        this.m_firstEx = e;
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block4;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return 1;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }

    public static class MenuTypeFilter
    implements IActionFilter {
        private final boolean m_visibleOnly;
        private final Set<? extends IMenuType> m_menuTypes;

        public MenuTypeFilter(Set<? extends IMenuType> menuTypes, boolean visibleOnly) {
            this.m_menuTypes = menuTypes;
            this.m_visibleOnly = visibleOnly;
        }

        @Override
        public boolean accept(IAction action) {
            if (action instanceof IMenu) {
                IMenu menu = (IMenu)action;
                if (this.isVisibleOnly() && !menu.isVisible()) {
                    return false;
                }
                if (menu.hasChildActions()) {
                    return !ActionUtility.normalizedActions(menu.getChildActions(), this).isEmpty();
                }
                if (this.getMenuTypes() != null) {
                    for (IMenuType iMenuType : this.getMenuTypes()) {
                        if (!menu.getMenuTypes().contains(iMenuType)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public Set<? extends IMenuType> getMenuTypes() {
            return this.m_menuTypes;
        }

        public boolean isVisibleOnly() {
            return this.m_visibleOnly;
        }
    }
}

