/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.annotations.OrderedComparator;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public final class CompositeFieldUtility {
    private CompositeFieldUtility() {
    }

    public static void addField(IFormField f, ICompositeField compositeField, List<IFormField> fields) {
        CompositeFieldUtility.checkFieldStateForMove(f);
        CompositeFieldUtility.checkFieldStateForMove(compositeField);
        if (f.getParentField() != null) {
            throw new IllegalArgumentException("field is already contained in '" + f.getParentField() + "'");
        }
        if (f.getForm() != null && f.getForm() != compositeField.getForm()) {
            throw new IllegalArgumentException("field is part of a different form,  '" + f.getForm() + "' instead of '" + compositeField.getForm() + "'");
        }
        fields.add(f);
        Collections.sort(fields, new OrderedComparator());
        f.setParentFieldInternal(compositeField);
        f.setFormInternal(compositeField.getForm());
        if (compositeField instanceof AbstractCompositeField) {
            f.addPropertyChangeListener((AbstractCompositeField)compositeField.new AbstractCompositeField.P_FieldPropertyChangeListener());
        }
    }

    public static void removeField(IFormField f, ICompositeField compositeField, List<IFormField> fields) {
        CompositeFieldUtility.checkFieldStateForMove(f);
        CompositeFieldUtility.checkFieldStateForMove(compositeField);
        if (!fields.remove(f)) {
            throw new IllegalArgumentException("field is not part of container '" + compositeField + "'");
        }
        f.setParentFieldInternal(null);
    }

    public static void moveFieldTo(IFormField f, ICompositeField oldContainer, ICompositeField newContainer, Map<Class<? extends IFormField>, IFormField> movedFormFieldsByClass) {
        if (f == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (oldContainer == null) {
            throw new IllegalArgumentException("old container must not be null");
        }
        if (newContainer == null) {
            throw new IllegalArgumentException("new container must not be null");
        }
        oldContainer.removeField(f);
        newContainer.addField(f);
        movedFormFieldsByClass.put(f.getClass(), f);
    }

    private static void checkFieldStateForMove(IFormField f) {
        if (f == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        IForm form = f.getForm();
        if (form == null) {
            return;
        }
        if (form.getHandler() == null) {
            return;
        }
        if (form.isShowing()) {
            throw new IllegalStateException("field '" + f + "' is already showing on desktop. Structural changes are not allowed anymore.");
        }
    }

    public static <T extends IFormField> T getFieldByClass(ICompositeField compositeField, final Class<T> formFieldClass) {
        T movedField = CompositeFieldUtility.getMovedFieldByClass(compositeField, formFieldClass);
        if (movedField != null) {
            return (T)((IFormField)formFieldClass.cast(movedField));
        }
        final Holder found = new Holder(formFieldClass);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                IFormField movedFieldByClass;
                if (field.getClass() == formFieldClass) {
                    found.setValue((Object)((IFormField)formFieldClass.cast(field)));
                } else if (field instanceof ICompositeField && (movedFieldByClass = CompositeFieldUtility.getMovedFieldByClass((ICompositeField)field, formFieldClass)) != null) {
                    found.setValue((Object)movedFieldByClass);
                }
                return found.getValue() == null;
            }
        };
        compositeField.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    private static <T extends IFormField> T getMovedFieldByClass(ICompositeField compositeField, Class<T> formFieldClass) {
        Map<Class<? extends IFormField>, IFormField> movedFields = compositeField.getMovedFields();
        IFormField f = movedFields.get(formFieldClass);
        return (T)((IFormField)formFieldClass.cast(f));
    }

    public static IFormField getFieldById(ICompositeField compositeField, String id) {
        return CompositeFieldUtility.getFieldById(compositeField, id, IFormField.class);
    }

    public static <T extends IFormField> T getFieldById(ICompositeField compositeField, final String id, final Class<T> type) {
        T movedField = CompositeFieldUtility.getMovedFieldById(compositeField, id, type);
        if (movedField != null) {
            return movedField;
        }
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                IFormField movedFieldById;
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)((IFormField)type.cast(field)));
                } else if (field instanceof ICompositeField && (movedFieldById = CompositeFieldUtility.getMovedFieldById((ICompositeField)field, id, type)) != null) {
                    found.setValue((Object)movedFieldById);
                }
                return found.getValue() == null;
            }
        };
        compositeField.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    private static <T extends IFormField> T getMovedFieldById(ICompositeField compositeField, String id, Class<T> type) {
        Collection<IFormField> movedFields = compositeField.getMovedFields().values();
        for (IFormField f : movedFields) {
            if (!type.isAssignableFrom(f.getClass()) || !f.getFieldId().equals(id)) continue;
            return (T)((IFormField)type.cast(f));
        }
        return null;
    }
}

