/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.ComposerFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.IComposerFieldExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.ComposerFieldDataModel;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.RootNode;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.AbstractComposerData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerAttributeNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEitherOrNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerEntityNodeData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.DataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.DataModelUtility;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="8e7f7eb8-be18-48e5-9efe-8a5b3459e247")
@FormData(value=AbstractComposerData.class, sdkCommand=FormData.SdkCommand.USE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE)
public abstract class AbstractComposerField
extends AbstractFormField
implements IComposerField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractComposerField.class);
    private IComposerFieldUIFacade m_uiFacade;
    private ITree m_tree;
    private SimpleXmlElement m_initValue;
    private IDataModel m_dataModel;

    public AbstractComposerField() {
        this(true);
    }

    public AbstractComposerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    public IDataModel getDataModel() {
        return this.m_dataModel;
    }

    @Override
    public void setDataModel(IDataModel dm) {
        this.m_dataModel = dm;
    }

    @ConfigOperation
    @Order(value=97.0)
    protected IDataModel execCreateDataModel() {
        ComposerFieldDataModel m = new ComposerFieldDataModel(this);
        m.init();
        return m;
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelEntity(IDataModelEntity e, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = e != null ? e.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=98.0)
    protected void execResolveRootPathForTopLevelAttribute(IDataModelAttribute a, List<IDataModelEntity> lifeList) {
        IDataModelEntity tmp = a != null ? a.getParentEntity() : null;
        while (tmp != null) {
            lifeList.add(0, tmp);
            tmp = tmp.getParentEntity();
        }
    }

    @ConfigOperation
    @Order(value=99.0)
    protected EntityPath execResolveEntityPath(EntityNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        EntityNode tmp = node;
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (list.size() > 0) {
            this.interceptResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        }
        return new EntityPath(list);
    }

    @ConfigOperation
    @Order(value=99.0)
    protected AttributePath execResolveAttributePath(AttributeNode node) {
        LinkedList<IDataModelEntity> list = new LinkedList<IDataModelEntity>();
        if (node == null) {
            return null;
        }
        EntityNode tmp = node.getAncestorNode(EntityNode.class);
        while (tmp != null) {
            if (tmp.getEntity() != null) {
                list.add(0, tmp.getEntity());
            }
            tmp = tmp.getAncestorNode(EntityNode.class);
        }
        if (list.size() > 0) {
            this.interceptResolveRootPathForTopLevelEntity((IDataModelEntity)list.get(0), list);
        } else {
            this.interceptResolveRootPathForTopLevelAttribute(node.getAttribute(), list);
        }
        return new AttributePath(list, node.getAttribute());
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractComposerField.class) continue;
            return c;
        }
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    protected RootNode execCreateRootNode() {
        return new RootNode(this);
    }

    @ConfigOperation
    @Order(value=110.0)
    protected EntityNode execCreateEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<? extends Object> values, List<String> texts) {
        EntityNode node = new EntityNode((IComposerField)this, e);
        node.setValues(values);
        node.setTexts(texts);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=120.0)
    protected AttributeNode execCreateAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<? extends Object> values, List<String> texts) {
        if (aggregationType != null && aggregationType == 0) {
            aggregationType = null;
        }
        AttributeNode node = new AttributeNode((IComposerField)this, a);
        node.setAggregationType(aggregationType);
        node.setOp(op);
        node.setValues(values);
        node.setTexts(texts);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=130.0)
    protected EitherOrNode execCreateEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = new EitherOrNode(this, true);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @ConfigOperation
    @Order(value=140.0)
    protected EitherOrNode execCreateAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        EitherOrNode node = new EitherOrNode(this, false);
        node.setNegative(negated);
        node.setStatus(1);
        return node;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.m_dataModel = this.interceptCreateDataModel();
        try {
            Class<? extends ITree> configuredTree;
            List contributedTrees = this.m_contributionHolder.getContributionsByClass(ITree.class);
            this.m_tree = (ITree)CollectionUtility.firstElement((List)contributedTrees);
            if (this.m_tree == null && (configuredTree = this.getConfiguredTree()) != null) {
                this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, configuredTree);
            }
            if (this.m_tree != null) {
                RootNode rootNode = this.interceptCreateRootNode();
                rootNode.getCellForUpdate().setText(this.getLabel());
                this.m_tree.setRootNode(rootNode);
                this.m_tree.setNodeExpanded(rootNode, true);
                this.m_tree.setEnabled(this.isEnabled());
                this.m_tree.addTreeListener(new TreeAdapter(){

                    @Override
                    public void treeChanged(TreeEvent e) {
                        switch (e.getType()) {
                            case 10: 
                            case 20: 
                            case 30: {
                                AbstractComposerField.this.checkSaveNeeded();
                                AbstractComposerField.this.checkEmpty();
                            }
                        }
                    }
                });
                this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (AbstractComposerField.this.m_tree != null) {
                            AbstractComposerField.this.m_tree.setEnabled(AbstractComposerField.this.isEnabled());
                        }
                    }
                });
            } else {
                LOG.warn("there is no inner class of type ITree in " + this.getClass().getName());
            }
        }
        catch (Exception e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating tree for composer field '" + this.getClass().getName() + "'.", (Throwable)e));
        }
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTree().initTree();
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTree().disposeTree();
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        if (this.m_tree != null) {
            AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)target;
            this.m_tree.exportTreeData(treeFieldData);
        }
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
        AbstractTreeFieldData treeFieldData = (AbstractTreeFieldData)source;
        if (treeFieldData.isValueSet() && this.m_tree != null) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.m_tree.importTreeData(treeFieldData);
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return this.m_dataModel.getAttributes();
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return this.m_dataModel.getEntities();
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        ITree tree = this.getTree();
        try {
            tree.setTreeChanging(true);
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            this.loadXMLRec(x, this.getTree().getRootNode());
        }
        finally {
            tree.setTreeChanging(false);
        }
    }

    private void loadXMLRec(SimpleXmlElement x, ITreeNode parent) {
        for (SimpleXmlElement xmlElem : x.getChildren()) {
            boolean negated;
            if ("attribute".equals(xmlElem.getName())) {
                IDataModelAttribute foundAtt;
                Integer aggregationType;
                IDataModelAttributeOp op;
                String id;
                block17: {
                    id = xmlElem.getStringAttribute("id");
                    try {
                        op = DataModelAttributeOp.create((int)xmlElem.getIntAttribute("op", 20));
                        aggregationType = xmlElem.getIntAttribute("aggregationType", 0);
                        if (aggregationType != 0) break block17;
                        aggregationType = null;
                    }
                    catch (Exception e) {
                        LOG.warn("read op", (Throwable)e);
                        continue;
                    }
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                try {
                    int i = 1;
                    while (i <= 5) {
                        String valueName;
                        String string = valueName = i == 1 ? "value" : "value" + i;
                        if (xmlElem.hasAttribute(valueName)) {
                            valueList.add(xmlElem.getObjectAttribute(valueName, null));
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    LOG.warn("read value for attribute " + id, (Throwable)e);
                    continue;
                }
                ArrayList<String> displayValueList = new ArrayList<String>();
                int i = 1;
                while (i <= 5) {
                    String displayValueName;
                    String string = displayValueName = i == 1 ? "displayValue" : "displayValue" + i;
                    if (xmlElem.hasAttribute(displayValueName)) {
                        displayValueList.add(xmlElem.getStringAttribute(displayValueName, null));
                    }
                    ++i;
                }
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)this.getDataModel(), (String)id);
                IDataModelAttribute iDataModelAttribute = foundAtt = attPath != null ? attPath.getAttribute() : null;
                if (foundAtt == null) {
                    LOG.warn("cannot find attribute with id=" + id);
                    continue;
                }
                AttributeNode node = this.addAttributeNode(parent, foundAtt, aggregationType, op, valueList, displayValueList);
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if ("entity".equals(xmlElem.getName())) {
                IDataModelEntity foundEntity;
                String id = xmlElem.getStringAttribute("id");
                negated = xmlElem.getStringAttribute("negated", "false").equalsIgnoreCase("true");
                String text = xmlElem.getStringAttribute("displayValues", null);
                EntityPath entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)this.getDataModel(), (String)id);
                IDataModelEntity iDataModelEntity = foundEntity = entityPath != null ? entityPath.lastElement() : null;
                if (foundEntity == null) {
                    LOG.warn("cannot find entity with id=" + id);
                    continue;
                }
                EntityNode node = this.addEntityNode(parent, foundEntity, negated, null, text != null ? Collections.singletonList(text) : null);
                if (node == null) continue;
                this.loadXMLRec(xmlElem, node);
                continue;
            }
            if (!"or".equals(xmlElem.getName())) continue;
            boolean beginning = xmlElem.getStringAttribute("begin", "false").equalsIgnoreCase("true");
            negated = xmlElem.getStringAttribute("negated", "false").equalsIgnoreCase("true");
            EitherOrNode node = null;
            if (beginning) {
                node = this.addEitherNode(parent, negated);
            } else {
                EitherOrNode orNode = null;
                for (ITreeNode n : parent.getChildNodes()) {
                    if (!(n instanceof EitherOrNode) || !((EitherOrNode)n).isBeginOfEitherOr()) continue;
                    orNode = (EitherOrNode)n;
                }
                if (orNode != null) {
                    node = this.addAdditionalOrNode(orNode, negated);
                }
            }
            if (node == null) continue;
            this.loadXMLRec(xmlElem, node);
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        super.storeXML(x);
        this.storeXMLRec(x, this.getTree().getRootNode());
    }

    private void createDataModelEntityPathRec(EntityNode node, List<IDataModelEntity> list) {
    }

    private void storeXMLRec(SimpleXmlElement x, ITreeNode parent) {
        for (ITreeNode node : parent.getChildNodes()) {
            if (node instanceof EntityNode) {
                EntityNode entityNode = (EntityNode)node;
                SimpleXmlElement xEntity = new SimpleXmlElement("entity");
                xEntity.setAttribute("id", (Object)DataModelUtility.entityPathToExternalId((IDataModel)this.getDataModel(), (EntityPath)this.interceptResolveEntityPath(entityNode)));
                xEntity.setAttribute("negated", (Object)(entityNode.isNegative() ? "true" : "false"));
                List<String> texts = entityNode.getTexts();
                xEntity.setAttribute("displayValues", CollectionUtility.hasElements(texts) ? StringUtility.emptyIfNull((Object)CollectionUtility.firstElement(texts)) : null);
                x.addChild(xEntity);
                this.storeXMLRec(xEntity, node);
                continue;
            }
            if (node instanceof AttributeNode) {
                List<Object> values;
                int i;
                List<String> texts;
                AttributeNode attNode = (AttributeNode)node;
                SimpleXmlElement xAtt = new SimpleXmlElement("attribute");
                xAtt.setAttribute("id", (Object)DataModelUtility.attributePathToExternalId((IDataModel)this.getDataModel(), (AttributePath)this.interceptResolveAttributePath(attNode)));
                IDataModelAttributeOp op = attNode.getOp();
                try {
                    xAtt.setAttribute("op", (Object)op.getOperator());
                    if (attNode.getAggregationType() != null) {
                        xAtt.setIntAttribute("aggregationType", attNode.getAggregationType().intValue());
                    }
                }
                catch (Exception e) {
                    LOG.warn("write op " + op, (Throwable)e);
                }
                if (CollectionUtility.hasElements(texts = attNode.getTexts())) {
                    Iterator<String> it = texts.iterator();
                    xAtt.setAttribute("displayValue", (Object)StringUtility.emptyIfNull((Object)it.next()));
                    i = 2;
                    while (it.hasNext()) {
                        xAtt.setAttribute("displayValue" + i, (Object)StringUtility.emptyIfNull((Object)it.next()));
                        ++i;
                    }
                }
                if ((values = attNode.getValues()) != null) {
                    i = 0;
                    for (Object value : values) {
                        String valueName = i == 0 ? "value" : "value" + (i + 1);
                        try {
                            xAtt.setObjectAttribute(valueName, value);
                        }
                        catch (Exception e) {
                            LOG.warn("write value[" + i + "] for attribute " + attNode.getAttribute() + ": " + value, (Throwable)e);
                        }
                        ++i;
                    }
                }
                x.addChild(xAtt);
                continue;
            }
            if (!(node instanceof EitherOrNode)) continue;
            EitherOrNode orNode = (EitherOrNode)node;
            SimpleXmlElement xOr = new SimpleXmlElement("or");
            xOr.setAttribute("begin", (Object)("" + orNode.isBeginOfEitherOr()));
            xOr.setAttribute("negated", (Object)(orNode.isNegative() ? "true" : "false"));
            x.addChild(xOr);
            this.storeXMLRec(xOr, node);
        }
    }

    @Override
    public void resetValue() {
        if (this.m_initValue == null) {
            this.getTree().removeAllChildNodes(this.getTree().getRootNode());
        } else {
            try {
                this.loadXML(this.m_initValue);
            }
            catch (ProcessingException e) {
                LOG.error("unexpected error occured while restoring initial value", (Throwable)e);
                this.getTree().removeAllChildNodes(this.getTree().getRootNode());
            }
        }
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public EntityNode addEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<? extends Object> values, List<String> texts) {
        EntityNode node = this.interceptCreateEntityNode(parentNode, e, negated, values, texts);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addEitherNode(ITreeNode parentNode, boolean negated) {
        EitherOrNode node = this.interceptCreateEitherNode(parentNode, negated);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public EitherOrNode addAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        EitherOrNode node = this.interceptCreateAdditionalOrNode(eitherOrNode, negated);
        if (node != null) {
            this.getTree().addChildNode(eitherOrNode.getChildNodeIndex() + 1, eitherOrNode.getParentNode(), node);
            this.getTree().setNodeExpanded(node, true);
        }
        return node;
    }

    @Override
    public AttributeNode addAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<? extends Object> values, List<String> texts) {
        AttributeNode node = this.interceptCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
        if (node != null) {
            this.getTree().addChildNode(parentNode, node);
        }
        return node;
    }

    public void updateInitialValue() {
        try {
            SimpleXmlElement element = new SimpleXmlElement();
            this.storeXML(element);
            this.m_initValue = element;
        }
        catch (ProcessingException e) {
            LOG.warn("unexpected error occured while storing initial value", (Throwable)e);
        }
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        boolean b = false;
        if (!b && this.m_tree.getDeletedNodeCount() > 0) {
            b = true;
        }
        if (!b && this.m_tree.getInsertedNodeCount() > 0) {
            b = true;
        }
        if (!b && this.m_tree.getUpdatedNodeCount() > 0) {
            b = true;
        }
        return b;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        try {
            this.m_tree.setTreeChanging(true);
            ITreeVisitor v = new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    if (!node.isStatusNonchanged()) {
                        node.setStatusInternal(0);
                        AbstractComposerField.this.m_tree.updateNode(node);
                    }
                    return true;
                }
            };
            this.m_tree.visitNode(this.m_tree.getRootNode(), v);
            this.m_tree.clearDeletedNodes();
            this.updateInitialValue();
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        return this.m_tree.getRootNode() == null || this.m_tree.getRootNode().getChildNodeCount() <= 0;
    }

    @Override
    public IComposerFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected final EntityPath interceptResolveEntityPath(EntityNode node) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveEntityPathChain chain = new ComposerFieldChains.ComposerFieldResolveEntityPathChain(extensions);
        return chain.execResolveEntityPath(node);
    }

    protected final void interceptResolveRootPathForTopLevelEntity(IDataModelEntity e, List<IDataModelEntity> lifeList) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain chain = new ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain(extensions);
        chain.execResolveRootPathForTopLevelEntity(e, lifeList);
    }

    protected final RootNode interceptCreateRootNode() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateRootNodeChain chain = new ComposerFieldChains.ComposerFieldCreateRootNodeChain(extensions);
        return chain.execCreateRootNode();
    }

    protected final AttributePath interceptResolveAttributePath(AttributeNode node) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveAttributePathChain chain = new ComposerFieldChains.ComposerFieldResolveAttributePathChain(extensions);
        return chain.execResolveAttributePath(node);
    }

    protected final AttributeNode interceptCreateAttributeNode(ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<? extends Object> values, List<String> texts) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateAttributeNodeChain chain = new ComposerFieldChains.ComposerFieldCreateAttributeNodeChain(extensions);
        return chain.execCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
    }

    protected final IDataModel interceptCreateDataModel() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateDataModelChain chain = new ComposerFieldChains.ComposerFieldCreateDataModelChain(extensions);
        return chain.execCreateDataModel();
    }

    protected final EitherOrNode interceptCreateEitherNode(ITreeNode parentNode, boolean negated) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateEitherNodeChain chain = new ComposerFieldChains.ComposerFieldCreateEitherNodeChain(extensions);
        return chain.execCreateEitherNode(parentNode, negated);
    }

    protected final void interceptResolveRootPathForTopLevelAttribute(IDataModelAttribute a, List<IDataModelEntity> lifeList) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain chain = new ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain(extensions);
        chain.execResolveRootPathForTopLevelAttribute(a, lifeList);
    }

    protected final EitherOrNode interceptCreateAdditionalOrNode(ITreeNode eitherOrNode, boolean negated) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain chain = new ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain(extensions);
        return chain.execCreateAdditionalOrNode(eitherOrNode, negated);
    }

    protected final EntityNode interceptCreateEntityNode(ITreeNode parentNode, IDataModelEntity e, boolean negated, List<? extends Object> values, List<String> texts) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerFieldChains.ComposerFieldCreateEntityNodeChain chain = new ComposerFieldChains.ComposerFieldCreateEntityNodeChain(extensions);
        return chain.execCreateEntityNode(parentNode, e, negated, values, texts);
    }

    protected IComposerFieldExtension<? extends AbstractComposerField> createLocalExtension() {
        return new LocalComposerFieldExtension<AbstractComposerField>(this);
    }

    protected static class LocalComposerFieldExtension<OWNER extends AbstractComposerField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IComposerFieldExtension<OWNER> {
        public LocalComposerFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public EntityPath execResolveEntityPath(ComposerFieldChains.ComposerFieldResolveEntityPathChain chain, EntityNode node) {
            return ((AbstractComposerField)this.getOwner()).execResolveEntityPath(node);
        }

        @Override
        public void execResolveRootPathForTopLevelEntity(ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelEntityChain chain, IDataModelEntity e, List<IDataModelEntity> lifeList) {
            ((AbstractComposerField)this.getOwner()).execResolveRootPathForTopLevelEntity(e, lifeList);
        }

        @Override
        public RootNode execCreateRootNode(ComposerFieldChains.ComposerFieldCreateRootNodeChain chain) {
            return ((AbstractComposerField)this.getOwner()).execCreateRootNode();
        }

        @Override
        public AttributePath execResolveAttributePath(ComposerFieldChains.ComposerFieldResolveAttributePathChain chain, AttributeNode node) {
            return ((AbstractComposerField)this.getOwner()).execResolveAttributePath(node);
        }

        @Override
        public AttributeNode execCreateAttributeNode(ComposerFieldChains.ComposerFieldCreateAttributeNodeChain chain, ITreeNode parentNode, IDataModelAttribute a, Integer aggregationType, IDataModelAttributeOp op, List<? extends Object> values, List<String> texts) {
            return ((AbstractComposerField)this.getOwner()).execCreateAttributeNode(parentNode, a, aggregationType, op, values, texts);
        }

        @Override
        public IDataModel execCreateDataModel(ComposerFieldChains.ComposerFieldCreateDataModelChain chain) {
            return ((AbstractComposerField)this.getOwner()).execCreateDataModel();
        }

        @Override
        public EitherOrNode execCreateEitherNode(ComposerFieldChains.ComposerFieldCreateEitherNodeChain chain, ITreeNode parentNode, boolean negated) {
            return ((AbstractComposerField)this.getOwner()).execCreateEitherNode(parentNode, negated);
        }

        @Override
        public void execResolveRootPathForTopLevelAttribute(ComposerFieldChains.ComposerFieldResolveRootPathForTopLevelAttributeChain chain, IDataModelAttribute a, List<IDataModelEntity> lifeList) {
            ((AbstractComposerField)this.getOwner()).execResolveRootPathForTopLevelAttribute(a, lifeList);
        }

        @Override
        public EitherOrNode execCreateAdditionalOrNode(ComposerFieldChains.ComposerFieldCreateAdditionalOrNodeChain chain, ITreeNode eitherOrNode, boolean negated) {
            return ((AbstractComposerField)this.getOwner()).execCreateAdditionalOrNode(eitherOrNode, negated);
        }

        @Override
        public EntityNode execCreateEntityNode(ComposerFieldChains.ComposerFieldCreateEntityNodeChain chain, ITreeNode parentNode, IDataModelEntity e, boolean negated, List<? extends Object> values, List<String> texts) {
            return ((AbstractComposerField)this.getOwner()).execCreateEntityNode(parentNode, e, negated, values, texts);
        }
    }

    private class P_UIFacade
    implements IComposerFieldUIFacade {
        private P_UIFacade() {
        }
    }

    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return true;
        }

        @Override
        protected void execDisposeTree() throws ProcessingException {
            super.execDisposeTree();
            this.visitTree(new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    if (node instanceof AbstractComposerNode) {
                        ((AbstractComposerNode)node).dispose();
                    }
                    return true;
                }
            });
        }

        @Override
        protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) throws ProcessingException {
            if (node instanceof EntityNode) {
                EntityNode enode = (EntityNode)node;
                String externalId = DataModelUtility.entityPathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (EntityPath)AbstractComposerField.this.interceptResolveEntityPath(enode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find entity data for: " + enode.getEntity());
                    }
                    return null;
                }
                ComposerEntityNodeData data = new ComposerEntityNodeData();
                data.setEntityExternalId(externalId);
                data.setNegative(enode.isNegative());
                return data;
            }
            if (node instanceof AttributeNode) {
                AttributeNode anode = (AttributeNode)node;
                String externalId = DataModelUtility.attributePathToExternalId((IDataModel)AbstractComposerField.this.getDataModel(), (AttributePath)AbstractComposerField.this.interceptResolveAttributePath(anode));
                if (externalId == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("could not find attribute data for: " + anode.getAttribute());
                    }
                    return null;
                }
                ComposerAttributeNodeData data = new ComposerAttributeNodeData();
                data.setAttributeExternalId(externalId);
                data.setNegative(false);
                data.setAggregationType(anode.getAggregationType());
                data.setOperator(anode.getOp().getOperator());
                data.setValues(anode.getValues());
                data.setTexts(anode.getTexts());
                return data;
            }
            if (node instanceof EitherOrNode) {
                EitherOrNode eonode = (EitherOrNode)node;
                ComposerEitherOrNodeData data = new ComposerEitherOrNodeData();
                data.setNegative(eonode.isNegative());
                data.setBeginOfEitherOr(eonode.isBeginOfEitherOr());
                return data;
            }
            return null;
        }

        @Override
        protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) throws ProcessingException {
            if (nodeData instanceof ComposerEntityNodeData) {
                IDataModelEntity e;
                ComposerEntityNodeData enodeData = (ComposerEntityNodeData)nodeData;
                String externalId = enodeData.getEntityExternalId();
                EntityPath entityPath = DataModelUtility.externalIdToEntityPath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelEntity iDataModelEntity = e = entityPath != null ? entityPath.lastElement() : null;
                if (e == null) {
                    LOG.warn("could not find entity for: " + enodeData.getEntityExternalId());
                    return null;
                }
                return AbstractComposerField.this.addEntityNode(parentNode, e, enodeData.isNegative(), null, enodeData.getTexts());
            }
            if (nodeData instanceof ComposerAttributeNodeData) {
                IDataModelAttributeOp op;
                IDataModelAttribute a;
                ComposerAttributeNodeData anodeData = (ComposerAttributeNodeData)nodeData;
                String externalId = anodeData.getAttributeExternalId();
                AttributePath attPath = DataModelUtility.externalIdToAttributePath((IDataModel)AbstractComposerField.this.getDataModel(), (String)externalId);
                IDataModelAttribute iDataModelAttribute = a = attPath != null ? attPath.getAttribute() : null;
                if (a == null) {
                    LOG.warn("could not find attribute for: " + anodeData.getAttributeExternalId());
                    return null;
                }
                try {
                    op = DataModelAttributeOp.create((int)anodeData.getOperator());
                }
                catch (Exception e) {
                    LOG.warn("read op " + anodeData.getOperator(), (Throwable)e);
                    return null;
                }
                return AbstractComposerField.this.addAttributeNode(parentNode, a, anodeData.getAggregationType(), op, anodeData.getValues(), anodeData.getTexts());
            }
            if (nodeData instanceof ComposerEitherOrNodeData) {
                ComposerEitherOrNodeData eonodeData = (ComposerEitherOrNodeData)nodeData;
                if (eonodeData.isBeginOfEitherOr()) {
                    return AbstractComposerField.this.addEitherNode(parentNode, eonodeData.isNegative());
                }
                ITreeNode eitherOrNode = parentNode.getChildNode(parentNode.getChildNodeCount() - 1);
                return AbstractComposerField.this.addAdditionalOrNode(eitherOrNode, eonodeData.isNegative());
            }
            return null;
        }

        @Override
        protected void execDecorateCell(ITreeNode node, Cell cell) throws ProcessingException {
            node.decorateCell();
            if (this.getIconId() != null) {
                cell.setIconId(this.getIconId());
            } else if (node instanceof RootNode) {
                cell.setIconId("composerfield_root");
            } else if (node instanceof EntityNode) {
                cell.setIconId("composerfield_entity");
            } else if (node instanceof AttributeNode) {
                if (((AttributeNode)node).getAggregationType() != null) {
                    cell.setIconId("composerfield_aggregation");
                } else {
                    cell.setIconId("composerfield_attribute");
                }
            } else if (node instanceof EitherOrNode) {
                cell.setIconId("composerfield_eitheror");
            }
        }
    }
}

