/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.comp;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class CLabelEx
extends CLabel {
    private static final int DRAW_FLAGS = 15;
    private static final String ELLIPSIS = "...";
    private boolean m_isFieldRangeLabel = false;

    public CLabelEx(Composite parent, int style) {
        super(parent, style);
    }

    public boolean isFieldRangeLabel() {
        return this.m_isFieldRangeLabel;
    }

    public void setFieldRangeLabel(boolean isFieldRangeLabel) {
        this.m_isFieldRangeLabel = isFieldRangeLabel;
    }

    protected String shortenText(GC gc, String t, int labelWidth) {
        if (t == null) {
            return null;
        }
        String text = t;
        String rangeWord = "";
        if (this.m_isFieldRangeLabel) {
            text = t.substring(0, t.lastIndexOf(32));
            rangeWord = t.substring(t.lastIndexOf(32));
        }
        int textWidth = gc.textExtent((String)ELLIPSIS, (int)15).x;
        int rangeWidth = gc.textExtent((String)rangeWord, (int)15).x;
        int s = text.length();
        while (s >= 0) {
            String s1 = t.substring(0, s);
            int l1 = gc.textExtent((String)s1, (int)15).x;
            if (l1 + textWidth + rangeWidth < labelWidth) {
                t = String.valueOf(s1) + ELLIPSIS + rangeWord;
                break;
            }
            --s;
        }
        return t;
    }
}

