/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy.strategy.workbench;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Form;

public class SwtScoutPartBlockingDecorator {
    private static final String ATTACH_MARKER_DATA = String.valueOf(SwtScoutPartBlockingDecorator.class.getName()) + "#marker";
    private final ISwtScoutPart m_part;
    private final boolean m_showCancelButton;
    private boolean m_attached;
    private Control m_oldFocus;
    private IContributionItem m_cancelAction;

    public SwtScoutPartBlockingDecorator(ISwtScoutPart part, boolean showCancelButton) {
        this.m_part = part;
        this.m_showCancelButton = showCancelButton;
    }

    public void attach(final IProgressMonitor monitor) {
        Form swtForm = this.m_part.getSwtForm();
        if (swtForm == null || swtForm.isDisposed()) {
            return;
        }
        if (swtForm.getData(ATTACH_MARKER_DATA) != null) {
            return;
        }
        this.m_attached = true;
        swtForm.setData(ATTACH_MARKER_DATA, (Object)true);
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl != null && SwtUtility.isAncestorOf((Control)swtForm, focusControl)) {
            this.m_oldFocus = focusControl;
        }
        if (this.m_showCancelButton) {
            if (this.m_cancelAction != null) {
                this.m_cancelAction.dispose();
            }
            this.m_cancelAction = new ContributionItem(){
                private ToolItem m_item;

                public void fill(ToolBar parent, int index) {
                    if (this.m_item == null) {
                        this.m_item = new ToolItem(parent, 8, index);
                        this.m_item.setImage(Activator.getIcon("progress_stop"));
                        this.m_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                monitor.setCanceled(true);
                                ((ToolItem)e.getSource()).setEnabled(false);
                            }
                        });
                    }
                }

                public void dispose() {
                    if (this.m_item != null) {
                        this.m_item.dispose();
                        this.m_item = null;
                    }
                }
            };
            swtForm.getToolBarManager().add(this.m_cancelAction);
            swtForm.getToolBarManager().update(true);
        }
        this.m_part.setBusy(true);
        swtForm.getBody().setEnabled(false);
        swtForm.layout(true);
    }

    public void detach() {
        if (!this.m_attached) {
            return;
        }
        this.m_attached = false;
        Form swtForm = this.m_part.getSwtForm();
        if (swtForm == null || swtForm.isDisposed()) {
            return;
        }
        swtForm.setData(ATTACH_MARKER_DATA, null);
        if (this.m_cancelAction != null) {
            swtForm.getToolBarManager().remove(this.m_cancelAction);
            this.m_cancelAction.dispose();
            this.m_cancelAction = null;
            swtForm.getToolBarManager().update(true);
        }
        this.m_part.setBusy(false);
        swtForm.getBody().setEnabled(true);
        swtForm.layout(true);
        if (this.m_oldFocus != null && !this.m_oldFocus.isDisposed() && this.m_part.isActive()) {
            this.m_oldFocus.forceFocus();
            this.m_oldFocus = null;
        }
    }
}

