/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.util.listener.DndAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;

public class StyledTextEx
extends StyledText {
    private final Listener m_traversHandlingListener = new P_TraverseHandlingListener();

    public StyledTextEx(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x200) != 0) {
            this.addListener(24, this.m_traversHandlingListener);
            this.updateVerticalScrollbarVisibility();
        }
        if ((style & 2) != 0) {
            this.attachMultiLineListeners();
        }
        P_DndListener dndListener = new P_DndListener();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.getTransfer();
        dropTarget.setTransfer(types);
        dropTarget.addDropListener((DropTargetListener)dndListener);
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)dndListener);
        this.setEnabled(true);
    }

    protected void checkSubclass() {
    }

    protected void attachMultiLineListeners() {
        this.addListener(31, this.m_traversHandlingListener);
        this.addListener(25, this.m_traversHandlingListener);
    }

    protected void dettachMultiLineListeners() {
        this.removeListener(31, this.m_traversHandlingListener);
        this.removeListener(25, this.m_traversHandlingListener);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateVerticalScrollbarVisibility();
    }

    protected void updateVerticalScrollbarVisibility() {
        Rectangle clientArea = this.getClientArea();
        Point size = this.computeSize(clientArea.width, -1, false);
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null && !vBar.isDisposed()) {
            vBar.setVisible(size.y > clientArea.height);
        }
    }

    public void paste() {
        super.paste();
        if (this.getTextLimit() > -1 && this.getText().length() > this.getTextLimit()) {
            this.setText(this.getText().substring(0, this.getTextLimit()));
            MessageBox messageBox = new MessageBox(this.getShell(), 32);
            messageBox.setText(SwtUtility.getNlsText(Display.getCurrent(), "Paste", new String[0]));
            messageBox.setMessage(SwtUtility.getNlsText(Display.getCurrent(), "PasteTextTooLongForFieldX", "" + this.getTextLimit()));
            messageBox.open();
        }
    }

    private class P_DndListener
    extends DndAdapter {
        private P_DndListener() {
        }

        @Override
        public void drop(DropTargetEvent event) {
            String text;
            if (StyledTextEx.this.getEnabled() && StyledTextEx.this.getEditable() && TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data) != null) {
                StyledTextEx.this.insert(text);
            }
        }

        @Override
        public void dragSetData(DragSourceEvent event) {
            event.data = StyledTextEx.this.getSelectionText();
        }
    }

    private class P_TraverseHandlingListener
    implements Listener {
        private long m_timestamp;

        private P_TraverseHandlingListener() {
        }

        public void handleEvent(Event event) {
            if (StyledTextEx.this.isDisposed()) {
                return;
            }
            if ((long)event.time == this.m_timestamp) {
                return;
            }
            switch (event.type) {
                case 31: {
                    if (event.keyCode != 9 || event.stateMask != 262144) break;
                    this.m_timestamp = event.time;
                    event.doit = false;
                    break;
                }
                case 25: {
                    if (!event.text.equals("\t") || event.stateMask != 0) break;
                    this.m_timestamp = event.time;
                    event.doit = false;
                    StyledTextEx.this.traverse(16);
                    break;
                }
                case 24: {
                    StyledTextEx.this.updateVerticalScrollbarVisibility();
                    break;
                }
            }
        }
    }
}

