/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class SwtScoutBasicFieldComposite<T extends IBasicField<?>>
extends SwtScoutValueFieldComposite<T> {
    private Point m_backupSelection = null;
    private TextFieldEditableSupport m_editableSupport;
    private boolean m_validateOnAnyKey;
    protected boolean m_updateDisplayTextOnModify;
    protected boolean m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown;

    protected void addModifyListenerForBasicField(Widget inputField) {
        TypedListener typedListener = new TypedListener((SWTEventListener)new P_SwtTextModifyListener());
        inputField.addListener(24, (Listener)typedListener);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IBasicField f = (IBasicField)this.getScoutObject();
        this.setValidateOnAnyKeyFromScout(f.isValidateOnAnyKey());
        this.setUpdateDisplayTextOnModifyFromScout(f.isUpdateDisplayTextOnModify());
    }

    @Override
    protected void setDisplayTextFromScout(String newText) {
        String oldText;
        if (newText == null) {
            newText = "";
        }
        if ((oldText = this.getText()) == null) {
            oldText = "";
        }
        if (oldText.equals(newText)) {
            return;
        }
        this.updateTextKeepCurserPosition(newText);
    }

    protected void updateTextKeepCurserPosition(String newText) {
        try {
            this.getUpdateSwtFromScoutLock().acquire();
            String oldText = this.getText();
            int startIndex = this.getSelection().x;
            int endIndex = this.getSelection().y;
            int caretPosition = this.getCaretOffset();
            if (startIndex == endIndex && startIndex == caretPosition && newText.length() != oldText.length()) {
                if (startIndex >= oldText.length()) {
                    startIndex = newText.length();
                } else if (newText.endsWith(oldText.substring(startIndex))) {
                    startIndex = newText.length() - oldText.substring(startIndex).length();
                }
                endIndex = startIndex;
                caretPosition = startIndex;
            }
            this.setText(newText);
            int textLength = newText.length();
            startIndex = Math.min(Math.max(startIndex, 0), textLength);
            endIndex = Math.min(Math.max(endIndex, 0), textLength);
            this.setCaretOffset(caretPosition);
            this.selectField(startIndex, endIndex);
        }
        finally {
            this.getUpdateSwtFromScoutLock().release();
        }
    }

    protected abstract String getText();

    protected abstract void setText(String var1);

    protected abstract Point getSelection();

    protected abstract void setSelection(int var1, int var2);

    protected abstract int getCaretOffset();

    protected abstract void setCaretOffset(int var1);

    protected abstract TextFieldEditableSupport createEditableSupport();

    protected void selectField(int startIndex, int endIndex) {
        this.m_backupSelection = new Point(startIndex, endIndex);
        this.setSelection(startIndex, endIndex);
    }

    protected void restoreSelection() {
        if (this.m_backupSelection != null && this.m_backupSelection.x != this.m_backupSelection.y) {
            this.setSelection(this.m_backupSelection.x, this.m_backupSelection.y);
        }
    }

    protected void clearSelection() {
        this.m_backupSelection = this.getSelection();
        if (this.m_backupSelection.y - this.m_backupSelection.x != 0) {
            this.setSelection(0, 0);
        }
    }

    protected void scheduleSelectAll() {
        this.getEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutBasicFieldComposite.this.getSwtField().isDisposed()) {
                    return;
                }
                SwtScoutBasicFieldComposite.this.setSelection(0, SwtScoutBasicFieldComposite.this.getText().length());
            }
        });
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = this.createEditableSupport();
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void handleSwtFocusGained() {
        this.scheduleSelectAll();
    }

    @Override
    protected void handleSwtFocusLost() {
        this.clearSelection();
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getText();
        if (!this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown && CompareUtility.equals((Object)text, (Object)((IBasicField)this.getScoutObject()).getDisplayText()) && ((IBasicField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IBasicField)SwtScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, false);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        if (this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown && !this.m_updateDisplayTextOnModify) {
            this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown = false;
        }
        return true;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("validateOnAnyKey")) {
            this.setValidateOnAnyKeyFromScout((Boolean)newValue);
        }
        if (name.equals("updateDisplayTextOnModify")) {
            this.setUpdateDisplayTextOnModifyFromScout((Boolean)newValue);
        }
    }

    private void setValidateOnAnyKeyFromScout(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    protected void setUpdateDisplayTextOnModifyFromScout(boolean b) {
        this.m_updateDisplayTextOnModify = b;
        if (b) {
            this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown = true;
        }
    }

    protected class P_SwtTextModifyListener
    implements ModifyListener {
        protected P_SwtTextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.setDisplayTextInScout();
            if (SwtScoutBasicFieldComposite.this.m_validateOnAnyKey && SwtScoutBasicFieldComposite.this.getUpdateSwtFromScoutLock().isReleased()) {
                this.sendVerifyToScoutAndIgnoreResponses();
            }
        }

        private void setDisplayTextInScout() {
            if (SwtScoutBasicFieldComposite.this.m_updateDisplayTextOnModify && SwtScoutBasicFieldComposite.this.getUpdateSwtFromScoutLock().isReleased()) {
                final String text = SwtScoutBasicFieldComposite.this.getText();
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IBasicField)SwtScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setDisplayTextFromUI(text);
                    }
                };
                SwtScoutBasicFieldComposite.this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }

        private void sendVerifyToScoutAndIgnoreResponses() {
            final String text = SwtScoutBasicFieldComposite.this.getText();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IBasicField)SwtScoutBasicFieldComposite.this.getScoutObject()).getUIFacade().setTextFromUI(text, true);
                }
            };
            SwtScoutBasicFieldComposite.this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

