/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironmentListener;
import org.eclipse.scout.rt.ui.swt.SwtEnvironmentEvent;

public abstract class AbstractSwtScoutCommandHandler
extends AbstractHandler {
    private final ISwtEnvironment m_environment;
    private final String m_actionQName;
    private IAction m_scoutAction;
    private P_ActionPropertyListener m_actionPropertyListener = new P_ActionPropertyListener();

    public AbstractSwtScoutCommandHandler(ISwtEnvironment environmet, String actionQName) {
        this.m_environment = environmet;
        this.m_actionQName = actionQName;
        if (!this.m_environment.isInitialized()) {
            this.m_environment.addEnvironmentListener(new P_EnvironmentListener());
        } else {
            this.setScoutAction(this.findAction());
        }
    }

    protected abstract IAction findAction();

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        if (this.getScoutAction() != null) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtScoutCommandHandler.this.getScoutAction().getUIFacade().fireActionFromUI();
                }
            };
            this.m_environment.invokeScoutLater(job, 0L);
        }
        return null;
    }

    protected void handleEnvironmentEvent(SwtEnvironmentEvent e) {
        switch (e.getType()) {
            case 2: {
                this.setScoutAction(this.findAction());
                break;
            }
            case 8: {
                this.m_scoutAction = null;
                this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
                break;
            }
        }
    }

    protected void updateHandler() {
    }

    public boolean isEnabled() {
        if (this.getScoutAction() == null) {
            return false;
        }
        return this.getScoutAction().isEnabled();
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IAction getScoutAction() {
        return this.m_scoutAction;
    }

    public void setScoutAction(IAction action) {
        if (this.m_scoutAction != null) {
            this.m_scoutAction.removePropertyChangeListener((PropertyChangeListener)this.m_actionPropertyListener);
        }
        this.m_scoutAction = action;
        if (this.m_scoutAction != null) {
            this.m_scoutAction.addPropertyChangeListener((PropertyChangeListener)this.m_actionPropertyListener);
        }
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    protected String getActionQName() {
        return this.m_actionQName;
    }

    protected void handlePropertyChanged(PropertyChangeEvent e) {
        if ("enabled" == e.getPropertyName()) {
            this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    private class P_ActionPropertyListener
    implements PropertyChangeListener {
        private P_ActionPropertyListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtScoutCommandHandler.this.handlePropertyChanged(evt);
                }
            };
            AbstractSwtScoutCommandHandler.this.getEnvironment().invokeSwtLater(job);
        }
    }

    private class P_EnvironmentListener
    implements ISwtEnvironmentListener {
        private P_EnvironmentListener() {
        }

        @Override
        public void environmentChanged(final SwtEnvironmentEvent e) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    AbstractSwtScoutCommandHandler.this.handleEnvironmentEvent(e);
                }
            };
            AbstractSwtScoutCommandHandler.this.m_environment.getDisplay().asyncExec(job);
        }
    }
}

