/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.operations;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtUtility;

public class NewNlsFileOperationDesc {
    public static final String PROP_PLUGIN = "plugin";
    public static final String PROP_FILE_NAME = "fileName";
    public static final String PROP_SRC_CONTAINER = "srcContainer";
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_PARENT_PLUGIN = "parentPlugin";
    public static final String PROP_PARENT_FILE = "parentFile";
    public static final String PROP_TRANSLATION_FOLDER = "translationFolder";
    public static final String PROP_TRANSLATION_FILE = "translationFile";
    private final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    public void setPlugin(IProject value) {
        this.m_propertySupport.setProperty(PROP_PLUGIN, (Object)value);
        try {
            if (value != null) {
                IJavaProject jp = JavaCore.create((IProject)value);
                ArrayList<IClasspathEntry> possibleEntries = new ArrayList<IClasspathEntry>();
                for (IClasspathEntry entry : NlsJdtUtility.getSourceLocations((IJavaProject)jp)) {
                    if (entry.getEntryKind() != 3) continue;
                    possibleEntries.add(entry);
                }
                if (possibleEntries.size() > 0) {
                    this.setSourceContainer(((IClasspathEntry)possibleEntries.get(0)).getPath());
                } else {
                    this.setSourceContainer(null);
                }
            } else {
                this.setSourceContainer(null);
            }
        }
        catch (JavaModelException e) {
            NlsCore.logWarning((Throwable)e);
            this.setSourceContainer(null);
        }
        this.setPackage(null);
    }

    public Map<String, Object> getPropertiesMap() {
        return this.m_propertySupport.getPropertiesMap();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public IProject getPlugin() {
        return (IProject)this.m_propertySupport.getProperty(PROP_PLUGIN);
    }

    public void setFileName(String value) {
        this.m_propertySupport.setPropertyString(PROP_FILE_NAME, value);
    }

    public String getFileName() {
        return this.m_propertySupport.getPropertyString(PROP_FILE_NAME);
    }

    public void setSourceContainer(IPath value) {
        this.m_propertySupport.setProperty(PROP_SRC_CONTAINER, (Object)value);
    }

    public IPath getSourceContainer() {
        return (IPath)this.m_propertySupport.getProperty(PROP_SRC_CONTAINER);
    }

    public void setPackage(String value) {
        this.m_propertySupport.setPropertyString(PROP_PACKAGE, value);
    }

    public String getPackage() {
        return this.m_propertySupport.getPropertyString(PROP_PACKAGE);
    }

    public void setClassName(String input) {
        if (!StringUtility.hasText((CharSequence)input)) {
            input = null;
        }
        this.m_propertySupport.setPropertyString(PROP_CLASS_NAME, input);
    }

    public String getClassName() {
        return this.m_propertySupport.getPropertyString(PROP_CLASS_NAME);
    }

    public void setParentPlugin(IPluginModelBase model) {
        this.m_propertySupport.setProperty(PROP_PARENT_PLUGIN, (Object)model);
    }

    public IPluginModelBase getParentPlugin() {
        return (IPluginModelBase)this.m_propertySupport.getProperty(PROP_PARENT_PLUGIN);
    }

    public void setParentFile(IFile file) {
        this.m_propertySupport.setProperty(PROP_PARENT_FILE, (Object)file);
    }

    public IFile getParentFile() {
        return (IFile)this.m_propertySupport.getProperty(PROP_PARENT_FILE);
    }

    public void setTranslationFolder(String folder) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FOLDER, folder);
    }

    public String getTranslationFolder() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FOLDER);
    }

    public void setTranlationFileName(String filename) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FILE, filename);
    }

    public String getTranlationFileName() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FILE);
    }
}

