/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.spellchecker.forms;

import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellCheckerService;
import org.eclipse.scout.rt.client.services.common.spellchecker.IUserDictionary;
import org.eclipse.scout.rt.client.services.common.spellchecker.forms.SpellCheckerLanguageLookupCall;
import org.eclipse.scout.rt.client.services.common.spellchecker.forms.SpellCheckerShortcutLookupCall;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.checkbox.AbstractCheckBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.service.SERVICES;

public class SpellCheckerOptionsForm
extends AbstractForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SpellCheckerOptionsForm.class);

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"SC_DialogTitle_Options", (String[])new String[0]);
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GeneralSettingsBox getGeneralSettingsBox() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.class);
    }

    public MainBox.UserDictionaryBox getUserDictionaryBox() {
        return this.getFieldByClass(MainBox.UserDictionaryBox.class);
    }

    public MainBox.GeneralSettingsBox.EnabledField getEnabledField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.EnabledField.class);
    }

    public MainBox.GeneralSettingsBox.ShortcutField getShortcutField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.ShortcutField.class);
    }

    public MainBox.GeneralSettingsBox.LanguageField getLanguageField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.LanguageField.class);
    }

    public MainBox.GeneralSettingsBox.IgnoreCaseField getIgnoreCaseField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.IgnoreCaseField.class);
    }

    public MainBox.GeneralSettingsBox.IgnoreDomainNamesField getIgnoreDomainNamesField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.IgnoreDomainNamesField.class);
    }

    public MainBox.GeneralSettingsBox.IgnoreWordsWithNumbersField getIgnoreWordsWithNumbersField() {
        return this.getFieldByClass(MainBox.GeneralSettingsBox.IgnoreWordsWithNumbersField.class);
    }

    public MainBox.UserDictionaryBox.UserDictionaryTableField getUserDictionaryTableField() {
        return this.getFieldByClass(MainBox.UserDictionaryBox.UserDictionaryTableField.class);
    }

    public MainBox.UserDictionaryBox.EditorSequenceBox getEditorSequenceBox() {
        return this.getFieldByClass(MainBox.UserDictionaryBox.EditorSequenceBox.class);
    }

    public MainBox.UserDictionaryBox.EditorSequenceBox.EditorField getEditorField() {
        return this.getFieldByClass(MainBox.UserDictionaryBox.EditorSequenceBox.EditorField.class);
    }

    public MainBox.UserDictionaryBox.EditorSequenceBox.EditorButton getEditorButton() {
        return this.getFieldByClass(MainBox.UserDictionaryBox.EditorSequenceBox.EditorButton.class);
    }

    public MainBox.ResetToStandardButton getResetToStandardButton() {
        return this.getFieldByClass(MainBox.ResetToStandardButton.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Order(value=70.0)
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=10.0)
        public class GeneralSettingsBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"SC_Label_Main", (String[])new String[0]);
            }

            @Order(value=10.0)
            public class EnabledField
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Label_Enable", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_Enable", (String[])new String[0]);
                }

                @Override
                protected void execChangedValue() throws ProcessingException {
                    boolean on = (Boolean)this.getValue();
                    SpellCheckerOptionsForm.this.getShortcutField().setEnabled(on);
                    SpellCheckerOptionsForm.this.getLanguageField().setEnabled(on);
                    SpellCheckerOptionsForm.this.getIgnoreCaseField().setEnabled(on);
                    SpellCheckerOptionsForm.this.getIgnoreDomainNamesField().setEnabled(on);
                    SpellCheckerOptionsForm.this.getIgnoreWordsWithNumbersField().setEnabled(on);
                }
            }

            @Order(value=40.0)
            public class IgnoreCaseField
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Label_IgnoreCase", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_IgnoreCase", (String[])new String[0]);
                }
            }

            @Order(value=50.0)
            public class IgnoreDomainNamesField
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Label_IgnoreDomainNames", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_IgnoreDomainNames", (String[])new String[0]);
                }
            }

            @Order(value=60.0)
            public class IgnoreWordsWithNumbersField
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Label_IgnoreWordsWithNumbers", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_IgnoreWordsWithNumbers", (String[])new String[0]);
                }
            }

            @Order(value=30.0)
            public class LanguageField
            extends AbstractSmartField<String> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Language", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_Language", (String[])new String[0]);
                }

                @Override
                protected Class<? extends ILookupCall<String>> getConfiguredLookupCall() {
                    return SpellCheckerLanguageLookupCall.class;
                }
            }

            @Order(value=20.0)
            public class ShortcutField
            extends AbstractSmartField<String> {
                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"SC_Label_Shortcut", (String[])new String[0]);
                }

                @Override
                protected String getConfiguredTooltipText() {
                    return ScoutTexts.get((String)"SC_Help_Shortcut", (String[])new String[0]);
                }

                @Override
                protected Class<? extends ILookupCall<String>> getConfiguredLookupCall() {
                    return SpellCheckerShortcutLookupCall.class;
                }
            }
        }

        @Order(value=60.0)
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=50.0)
        public class ResetToStandardButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"SC_Label_UseDefaults", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"SC_Help_UseDefaults", (String[])new String[0]);
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                SpellCheckerOptionsForm.this.getEnabledField().setValue(true);
                SpellCheckerOptionsForm.this.getShortcutField().setValue("f7");
                SpellCheckerOptionsForm.this.getLanguageField().setValue(LocaleThreadLocal.get().toString());
                SpellCheckerOptionsForm.this.getIgnoreCaseField().setValue(false);
                SpellCheckerOptionsForm.this.getIgnoreDomainNamesField().setValue(true);
                SpellCheckerOptionsForm.this.getIgnoreWordsWithNumbersField().setValue(true);
            }
        }

        @Order(value=20.0)
        public class UserDictionaryBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"SC_Label_UserDictionary", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"SC_Help_UserDictionary", (String[])new String[0]);
            }

            @Order(value=10.0)
            public class EditorSequenceBox
            extends AbstractSequenceBox {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Order(value=20.0)
                public class EditorButton
                extends AbstractButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"SC_Label_AddToDictionary", (String[])new String[0]);
                    }

                    @Override
                    protected String getConfiguredTooltipText() {
                        return ScoutTexts.get((String)"SC_Help_AddToDictionary", (String[])new String[0]);
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        String word = (String)SpellCheckerOptionsForm.this.getEditorField().getValue();
                        if (word != null) {
                            if (!((UserDictionaryTableField.Table)SpellCheckerOptionsForm.this.getUserDictionaryTableField().getTable()).getWordColumn().contains(word)) {
                                ((UserDictionaryTableField.Table)SpellCheckerOptionsForm.this.getUserDictionaryTableField().getTable()).addRowByArray(new Object[]{word});
                            }
                            SpellCheckerOptionsForm.this.getEditorField().setValue(null);
                        }
                    }
                }

                @Order(value=10.0)
                public class EditorField
                extends AbstractStringField {
                    @Override
                    public boolean isSpellCheckEnabled() {
                        return false;
                    }
                }
            }

            @Order(value=20.0)
            public class UserDictionaryTableField
            extends AbstractTableField<Table> {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Order(value=10.0)
                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    public WordColumn getWordColumn() {
                        return this.getColumnSet().getColumnByClass(WordColumn.class);
                    }

                    @Override
                    protected void execRowsSelected(List<? extends ITableRow> rows) throws ProcessingException {
                        if (CollectionUtility.hasElements(rows)) {
                            SpellCheckerOptionsForm.this.getEditorField().setValue((String)this.getWordColumn().getSelectedValue());
                        }
                    }

                    @Order(value=20.0)
                    public class RemoveWordMenu
                    extends AbstractMenu {
                        @Override
                        protected String getConfiguredText() {
                            return ScoutTexts.get((String)"SC_Label_RemoveWord", (String[])new String[0]);
                        }

                        @Override
                        protected String getConfiguredTooltipText() {
                            return ScoutTexts.get((String)"SC_Help_RemoveWord", (String[])new String[0]);
                        }

                        @Override
                        protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                            return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                        }

                        @Override
                        protected void execAction() throws ProcessingException {
                            if (MessageBox.showDeleteConfirmationMessage(Table.this.getWordColumn().getSelectedDisplayText())) {
                                Table.this.deleteRow(Table.this.getSelectedRow());
                            }
                        }
                    }

                    @Order(value=10.0)
                    public class WordColumn
                    extends AbstractStringColumn {
                        @Override
                        protected boolean getConfiguredPrimaryKey() {
                            return true;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return ScoutTexts.get((String)"SC_Label_IgnoredWord", (String[])new String[0]);
                        }
                    }
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            SpellCheckerOptionsForm.this.getShortcutField().setEnabledGranted(false);
            ISpellCheckerService sc = (ISpellCheckerService)SERVICES.getService(ISpellCheckerService.class);
            SpellCheckerOptionsForm.this.getEnabledField().setValue(sc.isEnabled());
            SpellCheckerOptionsForm.this.getShortcutField().setValue("f7");
            SpellCheckerOptionsForm.this.getLanguageField().setValue(sc.getLanguage());
            SpellCheckerOptionsForm.this.getIgnoreCaseField().setValue(sc.isIgnoreCase());
            SpellCheckerOptionsForm.this.getIgnoreDomainNamesField().setValue(sc.isIgnoreDomainNames());
            SpellCheckerOptionsForm.this.getIgnoreWordsWithNumbersField().setValue(sc.isIgnoreWordsWithNumbers());
            MainBox.UserDictionaryBox.UserDictionaryTableField.Table table = (MainBox.UserDictionaryBox.UserDictionaryTableField.Table)SpellCheckerOptionsForm.this.getUserDictionaryTableField().getTable();
            try {
                table.setTableChanging(true);
                IUserDictionary dict = sc.getUserDictionary();
                try {
                    dict.addWord("ReloadDictionaryTag");
                    dict.deleteWord("ReloadDictionaryTag");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Enumeration en = dict.words();
                while (en.hasMoreElements()) {
                    String s = (String)en.nextElement();
                    if (s == null || s.length() <= 0) continue;
                    table.addRowByArray(new Object[]{s});
                }
            }
            finally {
                table.setTableChanging(false);
            }
        }

        @Override
        protected void execStore() throws ProcessingException {
            ISpellCheckerService sc = (ISpellCheckerService)SERVICES.getService(ISpellCheckerService.class);
            boolean reinitNeeded = false;
            if (SpellCheckerOptionsForm.this.getUserDictionaryTableField().isSaveNeeded()) {
                reinitNeeded = true;
                MainBox.UserDictionaryBox.UserDictionaryTableField.Table table = (MainBox.UserDictionaryBox.UserDictionaryTableField.Table)SpellCheckerOptionsForm.this.getUserDictionaryTableField().getTable();
                try {
                    IUserDictionary dict = sc.getUserDictionary();
                    dict.clear();
                    for (String word : table.getWordColumn().getValues()) {
                        dict.addWord(word);
                    }
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            if (SpellCheckerOptionsForm.this.getGeneralSettingsBox().isSaveNeeded()) {
                reinitNeeded = true;
                sc.setEnabled((Boolean)SpellCheckerOptionsForm.this.getEnabledField().getValue());
                sc.setLanguage((String)SpellCheckerOptionsForm.this.getLanguageField().getValue());
                sc.setIgnoreCase((Boolean)SpellCheckerOptionsForm.this.getIgnoreCaseField().getValue());
                sc.setIgnoreDomainNames((Boolean)SpellCheckerOptionsForm.this.getIgnoreDomainNamesField().getValue());
                sc.setIgnoreWordsWithNumbers((Boolean)SpellCheckerOptionsForm.this.getIgnoreWordsWithNumbersField().getValue());
            }
            if (reinitNeeded) {
                sc.saveSettings();
                sc.reinitialize();
            }
        }
    }
}

