/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.runner;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.testing.shared.runner.TestEnvironmentUtility;
import org.eclipse.scout.rt.testing.shared.services.common.exceptionhandler.ProcessingRuntimeExceptionUnwrappingStatement;
import org.eclipse.scout.testing.client.DefaultTestClientSessionProvider;
import org.eclipse.scout.testing.client.ITestClientSessionProvider;
import org.eclipse.scout.testing.client.runner.IClientTestEnvironment;
import org.eclipse.scout.testing.client.runner.RunAftersInSeparateScoutClientSession;
import org.eclipse.scout.testing.client.runner.RunBeforesInSeparateScoutClientSession;
import org.eclipse.scout.testing.client.runner.ScoutClientJobWrapperStatement;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class ScoutClientTestRunner
extends BlockJUnit4ClassRunner {
    private static ITestClientSessionProvider s_defaultClientSessionProvider = new DefaultTestClientSessionProvider();
    private static Class<? extends IClientSession> s_defaultClientSessionClass;
    private static final IScoutLogger LOG;
    private static final IClientTestEnvironment CLIENT_TEST_ENVIRONMENT;
    private final IClientSession m_clientSession;

    static {
        LOG = ScoutLogManager.getLogger(ScoutClientTestRunner.class);
        CLIENT_TEST_ENVIRONMENT = (IClientTestEnvironment)TestEnvironmentUtility.createTestEnvironment(IClientTestEnvironment.class, (String)"org.eclipse.scout.testing.client.runner.customClientTestEnvironmentClassName", (String)"org.eclipse.scout.testing.client.runner.CustomClientTestEnvironment");
        if (CLIENT_TEST_ENVIRONMENT != null) {
            CLIENT_TEST_ENVIRONMENT.setupGlobalEnvironment();
        }
    }

    public ScoutClientTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        if (CLIENT_TEST_ENVIRONMENT != null) {
            CLIENT_TEST_ENVIRONMENT.setupInstanceEnvironment();
        }
        try {
            this.m_clientSession = this.getOrCreateClientSession(klass.getAnnotation(ClientTest.class), null);
        }
        catch (InitializationError e) {
            throw e;
        }
        catch (Exception e) {
            ArrayList<Exception> errors = new ArrayList<Exception>();
            errors.add(e);
            throw new InitializationError(errors);
        }
    }

    public static ITestClientSessionProvider getDefaultClientSessionProvider() {
        return s_defaultClientSessionProvider;
    }

    public static void setDefaultClientSessionProvider(ITestClientSessionProvider defaultClientSessionProvider) {
        s_defaultClientSessionProvider = defaultClientSessionProvider;
    }

    public static Class<? extends IClientSession> getDefaultClientSessionClass() {
        return s_defaultClientSessionClass;
    }

    public static void setDefaultClientSessionClass(Class<? extends IClientSession> defaultClientSessionClass) {
        s_defaultClientSessionClass = defaultClientSessionClass;
    }

    protected Class<? extends IClientSession> defaultClientSessionClass() {
        return ScoutClientTestRunner.getDefaultClientSessionClass();
    }

    protected ITestClientSessionProvider defaultClientSessionProvider() {
        return ScoutClientTestRunner.getDefaultClientSessionProvider();
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        return befores.isEmpty() ? statement : new RunBeforesInSeparateScoutClientSession(this.m_clientSession, statement, befores, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return afters.isEmpty() ? statement : new RunAftersInSeparateScoutClientSession(this.m_clientSession, statement, afters, null);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        try {
            IClientSession clientSession = this.getClientSession(method);
            return this.createWrappedStatement(super.methodBlock(method), clientSession);
        }
        catch (ProcessingException e1) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    throw e1;
                }
            };
        }
    }

    protected IClientSession getClientSession(FrameworkMethod method) throws ProcessingException {
        ClientTest methodLevelClientTest = (ClientTest)method.getAnnotation(ClientTest.class);
        if (methodLevelClientTest != null) {
            try {
                ClientTest classLevelClientTest = this.getTestClass().getJavaClass().getAnnotation(ClientTest.class);
                return this.getOrCreateClientSession(classLevelClientTest, methodLevelClientTest);
            }
            catch (Throwable e) {
                throw new ProcessingException("Could not create ClientSession", e);
            }
        }
        return this.m_clientSession;
    }

    protected Statement createWrappedStatement(Statement statement, IClientSession session) {
        return new ScoutClientJobWrapperStatement(session, statement);
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        return super.possiblyExpectingExceptions(method, test, (Statement)new ProcessingRuntimeExceptionUnwrappingStatement(next));
    }

    protected IClientSession getOrCreateClientSession(ClientTest classLevelClientTest, ClientTest methodLevelClientTest) throws Exception {
        Class<? extends IClientSession> clientSessionClass = this.defaultClientSessionClass();
        ITestClientSessionProvider sessionProvider = this.defaultClientSessionProvider();
        String runAs = null;
        boolean forceNewSession = false;
        if (classLevelClientTest != null) {
            clientSessionClass = this.extractClientSessionClass(classLevelClientTest, clientSessionClass);
            sessionProvider = this.extractSessionProvider(classLevelClientTest, sessionProvider);
            runAs = this.extractRunAs(classLevelClientTest, runAs);
            forceNewSession = this.extractForceNewSession(classLevelClientTest, forceNewSession);
        }
        if (methodLevelClientTest != null) {
            clientSessionClass = this.extractClientSessionClass(methodLevelClientTest, clientSessionClass);
            sessionProvider = this.extractSessionProvider(methodLevelClientTest, sessionProvider);
            runAs = this.extractRunAs(methodLevelClientTest, runAs);
            forceNewSession = this.extractForceNewSession(methodLevelClientTest, forceNewSession);
        }
        if (clientSessionClass == null) {
            throw new InitializationError("Client session class is not set. Either set the default client session using '" + ScoutClientTestRunner.class.getSimpleName() + ".setDefaultClientSessionClass' or annotate your test class and/or method with '" + ClientTest.class.getSimpleName() + "'");
        }
        return sessionProvider.getOrCreateClientSession(clientSessionClass, runAs, forceNewSession);
    }

    protected Class<? extends IClientSession> extractClientSessionClass(ClientTest clientTest, Class<? extends IClientSession> defaultValue) {
        if (clientTest == null || clientTest.clientSessionClass() == null || clientTest.clientSessionClass() == IClientSession.class) {
            return defaultValue;
        }
        return clientTest.clientSessionClass();
    }

    protected ITestClientSessionProvider extractSessionProvider(ClientTest clientTest, ITestClientSessionProvider defaultValue) throws Exception {
        if (clientTest == null || clientTest.sessionProvider() == null || clientTest.sessionProvider() == NullTestClientSessionProvider.class) {
            return defaultValue;
        }
        return clientTest.sessionProvider().newInstance();
    }

    protected String extractRunAs(ClientTest clientTest, String defaultValue) {
        String s;
        String runAs = defaultValue;
        if (clientTest != null && clientTest.runAs() != null && (s = clientTest.runAs().trim()).length() > 0) {
            runAs = s;
        }
        return runAs;
    }

    protected boolean extractForceNewSession(ClientTest clientTest, boolean defaultValue) {
        boolean forceCreateNewSession = defaultValue;
        if (clientTest != null) {
            forceCreateNewSession = clientTest.forceNewSession();
        }
        return forceCreateNewSession;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface ClientTest {
        public Class<? extends IClientSession> clientSessionClass() default IClientSession.class;

        public Class<? extends ITestClientSessionProvider> sessionProvider() default NullTestClientSessionProvider.class;

        public String runAs() default "";

        public boolean forceNewSession() default false;
    }

    public static interface NullTestClientSessionProvider
    extends ITestClientSessionProvider {
    }
}

