/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.jms;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractJndiService
extends AbstractService {
    private String m_jndiInitialContextFactory;
    private String m_jndiProviderUrl;
    private String m_jndiUrlPkgPrefixes;
    private String m_jndiProperties;
    private String m_securityPrincipal;
    private String m_securityCredentials;

    public void initializeService(ServiceRegistration registration) {
        this.initConfig();
        super.initializeService(registration);
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredJndiInitialContextFactory() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    protected String getConfiguredJndiProviderUrl() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    protected String getConfiguredJndiUrlPkgPrefixes() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=80.0)
    protected String getConfiguredJndiProperties() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredSecurityPrincipal() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected String getConfiguredSecurityCredentials() {
        return null;
    }

    public String getJndiInitialContextFactory() {
        return this.m_jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.m_jndiInitialContextFactory = jndiInitialContextFactory;
    }

    public String getJndiProviderUrl() {
        return this.m_jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.m_jndiProviderUrl = jndiProviderUrl;
    }

    public String getJndiUrlPkgPrefixes() {
        return this.m_jndiUrlPkgPrefixes;
    }

    public void setJndiUrlPkgPrefixes(String jndiUrlPkgPrefixes) {
        this.m_jndiUrlPkgPrefixes = jndiUrlPkgPrefixes;
    }

    public String getJndiProperties() {
        return this.m_jndiProperties;
    }

    public void setJndiProperties(String jndiProperties) {
        this.m_jndiProperties = jndiProperties;
    }

    public String getSecurityPrincipal() {
        return this.m_securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.m_securityPrincipal = securityPrincipal;
    }

    public String getSecurityCredentials() {
        return this.m_securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.m_securityCredentials = securityCredentials;
    }

    protected void initConfig() {
        this.setJndiInitialContextFactory(this.getConfiguredJndiInitialContextFactory());
        this.setJndiProviderUrl(this.getConfiguredJndiProviderUrl());
        this.setJndiUrlPkgPrefixes(this.getConfiguredJndiUrlPkgPrefixes());
        this.setJndiProperties(this.getConfiguredJndiProperties());
        this.setSecurityPrincipal(this.getConfiguredSecurityPrincipal());
        this.setSecurityCredentials(this.getConfiguredSecurityCredentials());
    }

    protected <T> T lookup(String name, Class<T> type) throws ProcessingException {
        Properties env = new Properties();
        if (StringUtility.hasText((CharSequence)this.getJndiProperties())) {
            InputStream jndiProperties = null;
            try {
                try {
                    jndiProperties = this.getJndiPorpertiesInputStream(this.getJndiProperties());
                    env.load(jndiProperties);
                }
                catch (Exception e) {
                    throw new ProcessingException("JNDI properties could not be loaded", (Throwable)e);
                }
            }
            finally {
                if (jndiProperties != null) {
                    try {
                        jndiProperties.close();
                    }
                    catch (IOException e) {
                        throw new ProcessingException("Unexpected", (Throwable)e);
                    }
                }
            }
        }
        if (StringUtility.hasText((CharSequence)this.getJndiInitialContextFactory())) {
            env.put("java.naming.factory.initial", this.getJndiInitialContextFactory());
        }
        if (StringUtility.hasText((CharSequence)this.getJndiProviderUrl())) {
            env.put("java.naming.provider.url", this.getJndiProviderUrl());
        }
        if (StringUtility.hasText((CharSequence)this.getJndiUrlPkgPrefixes())) {
            env.put("java.naming.factory.url.pkgs", this.getJndiUrlPkgPrefixes());
        }
        if (this.getSecurityPrincipal() != null) {
            env.put("java.naming.security.principal", this.getSecurityPrincipal());
        }
        if (this.getSecurityCredentials() != null) {
            env.put("java.naming.security.credentials", this.getSecurityCredentials());
        }
        return this.lookupAndCast(name, type, env);
    }

    protected <T> T lookupAndCast(String name, Class<T> type, Properties env) throws ProcessingException {
        Object o;
        block4: {
            InitialContext ctx = null;
            try {
                ctx = env.size() > 0 ? new InitialContext(env) : new InitialContext();
                o = ctx.lookup(name);
                if (o != null) break block4;
            }
            catch (NamingException e) {
                throw new ProcessingException("Error while looking up JNDI resource '" + name + "'", (Throwable)e);
            }
            return null;
        }
        if (type != null && !type.isAssignableFrom(o.getClass())) {
            throw new ProcessingException("Resolved object has unexpected type: expected '" + type + "', but has '" + o.getClass() + "'.");
        }
        return (T)o;
    }

    protected InputStream getJndiPorpertiesInputStream(String propertiesLocation) throws IOException {
        InputStream jndiProperties;
        try {
            URL url = new URL(propertiesLocation);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            jndiProperties = connection.getInputStream();
        }
        catch (MalformedURLException e) {
            jndiProperties = new FileInputStream(propertiesLocation);
        }
        return jndiProperties;
    }
}

