/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.ISpecProcessor;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.eclipse.scout.rt.spec.client.utility.SpecIOUtility;

public class HtmlFilePostProcessor
implements ISpecProcessor {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(HtmlFilePostProcessor.class);
    private String[] m_filenames;

    public HtmlFilePostProcessor(String ... filenames) {
        this.m_filenames = filenames;
    }

    @Override
    public void process() throws ProcessingException {
        String[] stringArray = this.m_filenames;
        int n = this.m_filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            File file = new File(ConfigRegistry.getSpecFileConfigInstance().getHtmlDir(), filename);
            if (file.exists()) {
                P_FirstProcessor firstProcessor = new P_FirstProcessor(filename);
                SpecIOUtility.process(file, firstProcessor);
                SpecIOUtility.replaceAll(file, firstProcessor.m_anchorIds);
            } else {
                LOG.warn("File " + file.getPath() + " does not exists!");
            }
            ++n2;
        }
    }

    protected final class P_FirstProcessor
    implements SpecIOUtility.IStringProcessor {
        private final String m_filename;
        protected HashMap<String, String> m_anchorIds = new HashMap();
        private long m_counter = 0L;

        private P_FirstProcessor(String filename) {
            this.m_filename = filename;
        }

        @Override
        public String processLine(String input) {
            String line = input.replace("<?xml version='1.0' encoding='utf-8' ?>", "");
            line = line.replace(String.valueOf(this.m_filename) + "#", "#");
            line = line.replaceAll("\\<span\\s+id=", "<a name=");
            Pattern pattern = Pattern.compile("\\<a name=\"([A-Za-z][A-Za-z0-9_\\.-]+)\"");
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                this.m_anchorIds.put("\"" + matcher.group(1) + "\"", "\"loa_" + this.m_counter + "\"");
                this.m_anchorIds.put("\"#" + matcher.group(1) + "\"", "\"#loa_" + this.m_counter + "\"");
                ++this.m_counter;
            }
            return line;
        }
    }
}

