/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.ArrayComparator;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.MatrixUtility;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityConfig;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityTableConfig;
import org.eclipse.scout.rt.spec.client.filter.FilterUtility;
import org.eclipse.scout.rt.spec.client.gen.extract.IDocTextExtractor;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.IDocTable;
import org.eclipse.scout.rt.spec.client.out.internal.DocTable;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public final class DocGenUtility {
    private DocGenUtility() {
    }

    public static String[] getHeaders(List<? extends IDocTextExtractor<?>> properties) {
        ArrayList<String> headers = new ArrayList<String>();
        if (properties != null) {
            for (IDocTextExtractor<?> p : properties) {
                headers.add(p.getHeader());
            }
        }
        return (String[])CollectionUtility.toArray(headers, String.class);
    }

    public static <T> String[] getTexts(T object, List<IDocTextExtractor<T>> properties) {
        if (properties != null) {
            String[] row = new String[properties.size()];
            int i = 0;
            while (i < properties.size()) {
                IDocTextExtractor<T> p = properties.get(i);
                row[i] = p.getText(object);
                ++i;
            }
            return row;
        }
        return null;
    }

    public static <T> IDocTable createDocTable(T entity, IDocEntityConfig<T> config, boolean transposedLayout) {
        List<IDocTextExtractor<T>> textExtractors = config.getPropertyTextExtractors();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] texts = DocGenUtility.getTexts(entity, textExtractors);
        if (texts != null && texts.length > 0) {
            rows.add(texts);
            String[][] rowArray = (String[][])CollectionUtility.toArray(rows, String[].class);
            String[] headers = DocGenUtility.getHeaders(textExtractors);
            return new DocTable(headers, rowArray, transposedLayout);
        }
        return null;
    }

    public static <T> IDocSection createDocSection(Collection<T> entities, IDocEntityTableConfig<T> config, boolean transposedLayout) {
        List<IDocTextExtractor<T>> textExtractors = config.getTextExtractors();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (T e : entities) {
            if (!FilterUtility.isAccepted(e, config.getFilters())) continue;
            String[] row = DocGenUtility.getTexts(e, textExtractors);
            rows.add(row);
        }
        if (rows.size() > 0) {
            Object[][] rowArray = (String[][])CollectionUtility.toArray(rows, String[].class);
            MatrixUtility.sortWithComparators((Object[][])rowArray, (ArrayComparator.ColumnComparator[])config.getSortColumns());
            String[] headers = DocGenUtility.getHeaders(textExtractors);
            DocTable table = new DocTable(headers, (String[][])rowArray, transposedLayout);
            return new Section(config.getTitle(), table, new IDocSection[0]);
        }
        return null;
    }
}

