/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;
import org.eclipse.scout.rt.spec.client.filter.FilterUtility;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.gen.IDocFormFieldVisitor;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.internal.DocTable;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public class FormFieldSpecsVisitor
implements IDocFormFieldVisitor {
    private final IDocConfig m_config;
    private final List<String[]> m_rows = new ArrayList<String[]>();

    public FormFieldSpecsVisitor(IDocConfig config) {
        this.m_config = config;
    }

    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (FilterUtility.isAccepted(field, this.m_config.getFormFieldTableConfig().getFilters())) {
            String[] row = DocGenUtility.getTexts(field, this.m_config.getFormFieldTableConfig().getTextExtractors());
            this.m_rows.add(row);
        }
        return true;
    }

    @Override
    public List<IDocSection> getDocSections() {
        String[][] rowArray = (String[][])CollectionUtility.toArray(this.m_rows, String[].class);
        String[] headers = DocGenUtility.getHeaders(this.m_config.getFormFieldTableConfig().getTextExtractors());
        DocTable table = new DocTable(headers, rowArray, false);
        String title = TEXTS.get((String)"org.eclipse.scout.rt.spec.fields");
        ArrayList<IDocSection> sections = new ArrayList<IDocSection>();
        sections.add(new Section(title, table, new IDocSection[0]));
        return sections;
    }
}

