/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.utility;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.gen.extract.SpecialDescriptionExtractor;

public final class SpecUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SpecUtility.class);
    private static Set<Class<?>> s_allClasses;
    public static final String DOC_ID_TRUE = "org.eclipse.scout.rt.spec.true";
    public static final String DOC_ID_FALSE = "org.eclipse.scout.rt.spec.false";

    private SpecUtility() {
    }

    public static String getSpecFileBaseName(ITypeWithClassId object) {
        return String.valueOf(object.getClass().getSimpleName()) + "_" + object.classId();
    }

    public static Set<Class<?>> getAllClasses(BundleInspector.IClassFilter filter) throws ProcessingException {
        if (s_allClasses == null) {
            s_allClasses = BundleInspector.getAllClasses((BundleInspector.IClassFilter)new BundleInspector.IClassFilter(){

                public boolean accept(Class c) {
                    return true;
                }
            });
        }
        HashSet filteredClasses = new HashSet();
        for (Class<?> c : s_allClasses) {
            if (!filter.accept(c)) continue;
            filteredClasses.add(c);
        }
        return filteredClasses;
    }

    public static String createAnchorId(ITypeWithClassId object) {
        String classId = object.classId();
        return SpecUtility.createAnchorId(classId);
    }

    public static String createAnchorId(String classId) {
        return "c_" + classId;
    }

    public static List<IMenu> expandMenuHierarchy(List<IMenu> menus) {
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        for (IMenu menu : menus) {
            SpecUtility.addMenuRecursive(menuList, menu);
        }
        return menuList;
    }

    private static void addMenuRecursive(ArrayList<IMenu> menuList, IMenu menu) {
        menuList.add(menu);
        for (IMenu subMenu : menu.getChildActions()) {
            SpecUtility.addMenuRecursive(menuList, subMenu);
        }
    }

    public static Set<Class<?>> getAllDocEntityClasses() throws ProcessingException {
        return SpecUtility.getAllClasses(new BundleInspector.IClassFilter(){

            public boolean accept(Class c) {
                return IForm.class.isAssignableFrom(c) || IPage.class.isAssignableFrom(c);
            }
        });
    }

    public static boolean isDocType(Class type, Class<?> supertype, boolean listTypesWithoutDoc) {
        if (type == null || !supertype.isAssignableFrom(type)) {
            return false;
        }
        if (listTypesWithoutDoc) {
            return !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
        }
        String typeDescription = new SpecialDescriptionExtractor(null, "_name").getText(type);
        return typeDescription != null;
    }

    public static String getBooleanText(boolean b) {
        return b ? TEXTS.get((String)DOC_ID_TRUE) : TEXTS.get((String)DOC_ID_FALSE);
    }
}

