/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class SingleLayout
extends AbstractLayoutManager2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SingleLayout.class);
    private Dimension[] m_sizes;

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        return this.m_sizes[sizeflag];
    }

    @Override
    protected void validateLayout(Container parent) {
        this.m_sizes = null;
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.isVisible()) {
                this.m_sizes = SwingLayoutUtility.getValidatedSizes(c);
                int sizeflag = 0;
                while (sizeflag < 3) {
                    Insets i = parent.getInsets();
                    this.m_sizes[sizeflag].width += i.left + i.right;
                    this.m_sizes[sizeflag].height += i.top + i.bottom;
                    ++sizeflag;
                }
            }
            ++n2;
        }
        if (this.m_sizes == null) {
            this.m_sizes = new Dimension[]{new Dimension(), new Dimension(), new Dimension()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            if (!SwingUtility.IS_JAVA_7_OR_GREATER && SwingUtility.DO_RESET_COMPONENT_BOUNDS) {
                SwingUtility.setZeroBounds(parent.getComponents());
            }
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c.isVisible()) {
                    Rectangle r = new Rectangle(new Point(0, 0), parent.getSize());
                    this.subtractInsets(parent, r);
                    c.setBounds(r);
                    break;
                }
                ++n2;
            }
        }
    }

    private void subtractInsets(Container parent, Rectangle r) {
        Insets i = parent.getInsets();
        if (i != null) {
            r.x += i.left;
            r.y += i.top;
            r.width -= i.left + i.right;
            r.height -= i.top + i.bottom;
        }
    }
}

