/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swing.Activator;

public class SortIconUtility {
    private static final float BRIGHTEN_FACTOR = 1.6f;
    private static final Icon m_sortUpIcon = Activator.getIcon("table_sort_asc");
    private static final Icon m_sortDownIcon = Activator.getIcon("table_sort_desc");

    private SortIconUtility() {
    }

    private static Icon changeBrightness(Icon icon, float factor) {
        if (icon == null || !(icon instanceof ImageIcon)) {
            return icon;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        ImageIcon ret = new ImageIcon();
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        image.getGraphics().drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        RescaleOp op = new RescaleOp(factor, 0.0f, null);
        image = op.filter(image, image);
        ret.setImage(image);
        return ret;
    }

    public static Icon createSortIcon(IColumn column, List<? extends IColumn<?>> sortColumns, boolean ascending) {
        if (column == null || sortColumns == null) {
            return null;
        }
        float count = sortColumns.size();
        float factor = 1.0f + (float)column.getSortIndex() / count * 1.6f;
        Icon icon = m_sortDownIcon;
        if (ascending) {
            icon = m_sortUpIcon;
        }
        return SortIconUtility.changeBrightness(icon, factor);
    }
}

