/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table.celleditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.swing.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutDropDownPopup;

public class SwingScoutFormFieldPopup
extends SwingScoutComposite<IFormField> {
    private SwingScoutDropDownPopup m_swingScoutPopup;
    private ISwingScoutFormField<IFormField> m_innerSwingScoutFormField;
    private JComponent m_owner;
    private int m_minWidth;
    private int m_prefWidth;
    private int m_minHeight;
    private int m_prefHeight;
    private SwingScoutViewListener m_popupEventListener;
    private FocusTraversalPolicy m_focusTraversalPolicy;
    private List<IFormFieldPopupEventListener> m_eventListeners = new ArrayList<IFormFieldPopupEventListener>();
    private Object m_eventListenerLock = new Object();

    public SwingScoutFormFieldPopup(JComponent owner) {
        this.m_owner = owner;
        this.m_popupEventListener = new P_PopupEventListener();
        this.m_focusTraversalPolicy = new SwingScoutFocusTraversalPolicy();
    }

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_owner.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!e.getComponent().isShowing()) {
                    return;
                }
                SwingScoutFormFieldPopup.this.m_owner.removeHierarchyListener(this);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup = new SwingScoutDropDownPopup(SwingScoutFormFieldPopup.this.getSwingEnvironment(), (Component)SwingScoutFormFieldPopup.this.m_owner, null);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup.setResizable(true);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup.setPopupOnField(true);
                if (SwingScoutFormFieldPopup.this.m_prefWidth > 0 || SwingScoutFormFieldPopup.this.m_prefHeight > 0) {
                    SwingScoutFormFieldPopup.this.m_swingScoutPopup.getSwingWindow().setPreferredSize(SwingScoutFormFieldPopup.this.toValidDimension(new Dimension(SwingScoutFormFieldPopup.this.m_prefWidth, SwingScoutFormFieldPopup.this.m_prefHeight)));
                }
                if (SwingScoutFormFieldPopup.this.m_minWidth > 0 || SwingScoutFormFieldPopup.this.m_minHeight > 0) {
                    SwingScoutFormFieldPopup.this.m_swingScoutPopup.getSwingWindow().setMinimumSize(SwingScoutFormFieldPopup.this.toValidDimension(new Dimension(SwingScoutFormFieldPopup.this.m_minWidth, SwingScoutFormFieldPopup.this.m_minHeight)));
                }
                SwingScoutFormFieldPopup.this.m_innerSwingScoutFormField = SwingScoutFormFieldPopup.this.getSwingEnvironment().createFormField(SwingScoutFormFieldPopup.this.m_swingScoutPopup.getSwingContentPane(), (IFormField)SwingScoutFormFieldPopup.this.getScoutObject());
                JPanelEx rootPanel = new JPanelEx(new LogicalGridLayout(SwingScoutFormFieldPopup.this.getSwingEnvironment(), 1, 0));
                rootPanel.setOpaque(false);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup.getSwingContentPane().add(rootPanel);
                JScrollPaneEx scrollPane = new JScrollPaneEx(SwingScoutFormFieldPopup.this.getInnerSwingField());
                scrollPane.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(SwingScoutFormFieldPopup.this.getSwingEnvironment(), ((IFormField)SwingScoutFormFieldPopup.this.getScoutObject()).getGridData()));
                scrollPane.setBorder(null);
                rootPanel.add(scrollPane);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup.addSwingScoutViewListener(SwingScoutFormFieldPopup.this.m_popupEventListener);
                SwingScoutFormFieldPopup.this.m_swingScoutPopup.openView();
                SwingScoutFormFieldPopup.this.installTraverseKeyStrokes(scrollPane);
            }
        });
        this.m_owner.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SwingScoutFormFieldPopup.this.m_swingScoutPopup != null) {
                    SwingScoutFormFieldPopup.this.m_swingScoutPopup.autoAdjustBounds();
                }
            }
        });
        this.setSwingField(this.m_owner);
    }

    private void installTraverseKeyStrokes(JComponent component) {
        JComponent c;
        Component firstComponent = this.m_focusTraversalPolicy.getFirstComponent(component);
        Component lastComponent = this.m_focusTraversalPolicy.getFirstComponent(component);
        component.getInputMap(1).put(SwingUtility.createKeystroke("pressed ESCAPE"), "escape");
        component.getActionMap().put("escape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingScoutFormFieldPopup.this.closePopup(2);
            }
        });
        if (firstComponent instanceof JComponent) {
            c = (JComponent)firstComponent;
            c.setFocusTraversalKeys(1, new HashSet());
            c.getInputMap(0).put(SwingUtility.createKeystroke("shift TAB"), "reverse-tab");
            c.getActionMap().put("reverse-tab", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutFormFieldPopup.this.closePopup(9);
                }
            });
        }
        if (lastComponent instanceof JComponent) {
            c = (JComponent)lastComponent;
            c.setFocusTraversalKeys(0, new HashSet());
            c.addKeyListener(new KeyAdapter(){
                private boolean m_controlDown;

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 17) {
                        this.m_controlDown = true;
                    }
                    if (e.getKeyCode() == 9 && !this.m_controlDown && !e.isShiftDown()) {
                        SwingScoutFormFieldPopup.this.closePopup(5);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 17) {
                        this.m_controlDown = false;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEventListeners(FormFieldPopupEvent event) {
        IFormFieldPopupEventListener[] eventListeners;
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            eventListeners = this.m_eventListeners.toArray(new IFormFieldPopupEventListener[this.m_eventListeners.size()]);
        }
        IFormFieldPopupEventListener[] iFormFieldPopupEventListenerArray = eventListeners;
        int n = eventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFormFieldPopupEventListener eventListener = iFormFieldPopupEventListenerArray[n2];
            eventListener.handleEvent(event);
            ++n2;
        }
    }

    public void closePopup(int type) {
        if (this.isClosed()) {
            return;
        }
        if (this.getInnerSwingField() != null && this.getInnerSwingField().getInputVerifier() != null) {
            this.getInnerSwingField().getInputVerifier().verify(this.getInnerSwingField());
        }
        try {
            this.m_swingScoutPopup.removeSwingScoutViewListener(this.m_popupEventListener);
            this.m_swingScoutPopup.closeView();
            this.m_swingScoutPopup = null;
        }
        finally {
            this.notifyEventListeners(new FormFieldPopupEvent((IFormField)this.getScoutObject(), type));
        }
    }

    public int getMinWidth() {
        return this.m_minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public int getPrefWidth() {
        return this.m_prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        this.m_prefWidth = prefWidth;
    }

    public int getMinHeight() {
        return this.m_minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.m_minHeight = minHeight;
    }

    public int getPrefHeight() {
        return this.m_prefHeight;
    }

    public void setPrefHeight(int prefHeight) {
        this.m_prefHeight = prefHeight;
    }

    public SwingScoutDropDownPopup getPopup() {
        return this.m_swingScoutPopup;
    }

    public boolean isClosed() {
        return this.m_swingScoutPopup == null;
    }

    public JComponent getInnerSwingField() {
        JComponent component = this.m_innerSwingScoutFormField.getSwingField();
        if (component == null) {
            component = this.m_innerSwingScoutFormField.getSwingContainer();
        }
        return component;
    }

    private Dimension toValidDimension(Dimension dimension) {
        if (dimension.width == 0) {
            dimension.width = this.getSwingEnvironment().getFormColumnWidth() / 2;
        }
        if (dimension.height == 0) {
            dimension.height = this.getSwingEnvironment().getFormColumnWidth() / 2;
        }
        return dimension;
    }

    private class P_PopupEventListener
    implements SwingScoutViewListener {
        private P_PopupEventListener() {
        }

        @Override
        public void viewChanged(SwingScoutViewEvent e) {
            if (e.getType() == 10) {
                if (SwingScoutFormFieldPopup.this.m_swingScoutPopup == null) {
                    return;
                }
                JComponent contentPane = SwingScoutFormFieldPopup.this.m_swingScoutPopup.getSwingContentPane();
                if (contentPane == null) {
                    return;
                }
                final Component firstComponent = SwingScoutFormFieldPopup.this.m_focusTraversalPolicy.getFirstComponent(contentPane);
                if (firstComponent == null) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        firstComponent.requestFocus();
                    }
                });
            } else if (e.getType() == 40) {
                SwingScoutFormFieldPopup.this.closePopup(1);
            }
        }
    }
}

