/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.StringUtility;

public class HtmlViewCache {
    private HashMap<Object, View> m_viewMap = new HashMap();

    public void updateHtmlView(JLabel label, boolean customForeground) {
        String text = label.getText();
        View value = null;
        if (BasicHTML.isHTMLString(text)) {
            if (!customForeground) {
                label.setForeground(label.isEnabled() ? UIManager.getDefaults().getColor("TextField.foreground") : UIManager.getDefaults().getColor("TextField.inactiveForeground"));
            }
            Color fg = label.getForeground();
            String key = Base64Utility.encode((byte[])StringUtility.compress((String)(String.valueOf(text) + "." + label.getFont() + "." + (fg != null ? fg.getRGB() : 0))));
            value = this.m_viewMap.get(key);
            if (value == null && (value = BasicHTML.createHTMLView(label, text)) != null) {
                this.m_viewMap.put(key, value);
            }
        }
        label.putClientProperty("html", value);
    }
}

