/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.ViewSplit;

class ViewElement {
    public ViewSplit top;
    public ViewSplit bottom;
    public ViewSplit left;
    public ViewSplit right;
    private JInternalFrame m_frame;

    public ViewElement(JInternalFrame frame) {
        this.m_frame = frame;
    }

    public JInternalFrame getFrame() {
        return this.m_frame;
    }

    void validateMinMaxSizes() {
        Dimension[] sizes = SwingLayoutUtility.getValidatedSizes(this.m_frame);
        Dimension d = new Dimension(this.right.getLocation() - this.left.getLocation(), this.bottom.getLocation() - this.top.getLocation());
        int dy = sizes[0].height - d.height;
        if (dy > 0) {
            if (!this.top.isFixed()) {
                this.top.move(-dy, true);
            } else {
                this.bottom.move(dy, true);
            }
        }
        if ((dy = d.height - sizes[2].height) > 0) {
            if (!this.top.isFixed()) {
                this.top.move(dy, true);
            } else {
                this.bottom.move(-dy, true);
            }
        }
    }

    public void fitSize(Dimension size) {
        Dimension d = new Dimension(this.right.getLocation() - this.left.getLocation(), this.bottom.getLocation() - this.top.getLocation());
        int dy = size.height - d.height;
        if (dy > 0) {
            dy -= this.bottom.move(dy, false);
            this.top.move(-dy, false);
        }
        if ((dy = d.height - size.height) > 0) {
            dy -= this.top.move(dy, false);
            this.bottom.move(-dy, false);
        }
    }

    public void resize(Rectangle newR) {
        int dy;
        int dx;
        Rectangle oldR = this.m_frame.getBounds();
        if (oldR.x != newR.x) {
            dx = newR.x - oldR.x;
            this.left.move(dx, false);
        } else if (oldR.x + oldR.width != newR.x + newR.width) {
            dx = newR.x + newR.width - oldR.x - oldR.width;
            this.right.move(dx, false);
        }
        if (oldR.y != newR.y) {
            dy = newR.y - oldR.y;
            this.top.move(dy, false);
        } else if (oldR.y + oldR.height != newR.y + newR.height) {
            dy = newR.y + newR.height - oldR.y - oldR.height;
            this.bottom.move(dy, false);
        }
    }
}

