/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.text.StyleContext;
import javax.swing.text.html.CSS;
import org.eclipse.scout.commons.ReflectionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class CSSPatch {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CSSPatch.class);
    public static final CSS.Attribute AZIMUTH = CSSPatch.createAttribute("azimuth", null, false);
    public static final CSS.Attribute BORDER_BOTTOM_COLOR = CSSPatch.createAttribute("border-bottom-color", null, false);
    public static final CSS.Attribute BORDER_BOTTOM_STYLE = CSSPatch.createAttribute("border-bottom-style", null, false);
    public static final CSS.Attribute BORDER_COLLAPSE = CSSPatch.createAttribute("border-collapse", null, false);
    public static final CSS.Attribute BORDER_LEFT_COLOR = CSSPatch.createAttribute("border-left-color", null, false);
    public static final CSS.Attribute BORDER_LEFT_STYLE = CSSPatch.createAttribute("border-left-style", null, false);
    public static final CSS.Attribute BORDER_RIGHT_COLOR = CSSPatch.createAttribute("border-right-color", null, false);
    public static final CSS.Attribute BORDER_RIGHT_STYLE = CSSPatch.createAttribute("border-right-style", null, false);
    public static final CSS.Attribute BORDER_SPACING = CSSPatch.createAttribute("border-spacing", null, false);
    public static final CSS.Attribute BORDER_TOP_COLOR = CSSPatch.createAttribute("border-top-color", null, false);
    public static final CSS.Attribute BORDER_TOP_STYLE = CSSPatch.createAttribute("border-top-style", null, false);
    public static final CSS.Attribute BOTTOM = CSSPatch.createAttribute("bottom", null, false);
    public static final CSS.Attribute CAPTION_SIDE = CSSPatch.createAttribute("caption-side", null, false);
    public static final CSS.Attribute CLIP = CSSPatch.createAttribute("clip", null, false);
    public static final CSS.Attribute CONTENT = CSSPatch.createAttribute("content", null, false);
    public static final CSS.Attribute COUNTER_INCREMENT = CSSPatch.createAttribute("counter-increment", null, false);
    public static final CSS.Attribute COUNTER_RESET = CSSPatch.createAttribute("counter-reset", null, false);
    public static final CSS.Attribute CUE = CSSPatch.createAttribute("cue", null, false);
    public static final CSS.Attribute CUE_AFTER = CSSPatch.createAttribute("cue-after", null, false);
    public static final CSS.Attribute CUE_BEFORE = CSSPatch.createAttribute("cue-before", null, false);
    public static final CSS.Attribute CURSOR = CSSPatch.createAttribute("cursor", null, false);
    public static final CSS.Attribute DIRECTION = CSSPatch.createAttribute("direction", null, false);
    public static final CSS.Attribute ELEVATION = CSSPatch.createAttribute("elevation", null, false);
    public static final CSS.Attribute EMPTY_CELLS = CSSPatch.createAttribute("empty-cells", null, false);
    public static final CSS.Attribute LEFT = CSSPatch.createAttribute("left", null, false);
    public static final CSS.Attribute MAX_HEIGHT = CSSPatch.createAttribute("max-height", null, false);
    public static final CSS.Attribute MAX_WIDTH = CSSPatch.createAttribute("max-width", null, false);
    public static final CSS.Attribute MIN_HEIGHT = CSSPatch.createAttribute("min-height", null, false);
    public static final CSS.Attribute MIN_WIDTH = CSSPatch.createAttribute("min-width", null, false);
    public static final CSS.Attribute ORPHANS = CSSPatch.createAttribute("orphans", null, false);
    public static final CSS.Attribute OUTLINE = CSSPatch.createAttribute("outline", null, false);
    public static final CSS.Attribute OUTLINE_COLOR = CSSPatch.createAttribute("outline-color", null, false);
    public static final CSS.Attribute OUTLINE_STYLE = CSSPatch.createAttribute("outline-style", null, false);
    public static final CSS.Attribute OUTLINE_WIDTH = CSSPatch.createAttribute("outline-width", null, false);
    public static final CSS.Attribute OVERFLOW = CSSPatch.createAttribute("overflow", null, false);
    public static final CSS.Attribute PAGE_BREAK_AFTER = CSSPatch.createAttribute("page-break-after", null, false);
    public static final CSS.Attribute PAGE_BREAK_BEFORE = CSSPatch.createAttribute("page-break-before", null, false);
    public static final CSS.Attribute PAGE_BREAK_INSIDE = CSSPatch.createAttribute("page-break-inside", null, false);
    public static final CSS.Attribute PAUSE = CSSPatch.createAttribute("pause", null, false);
    public static final CSS.Attribute PAUSE_AFTER = CSSPatch.createAttribute("pause-after", null, false);
    public static final CSS.Attribute PAUSE_BEFORE = CSSPatch.createAttribute("pause-before", null, false);
    public static final CSS.Attribute PITCH = CSSPatch.createAttribute("pitch", null, false);
    public static final CSS.Attribute PITCH_RANGE = CSSPatch.createAttribute("pitch-range", null, false);
    public static final CSS.Attribute PLAY_DURING = CSSPatch.createAttribute("play-during", null, false);
    public static final CSS.Attribute POSITION = CSSPatch.createAttribute("position", null, false);
    public static final CSS.Attribute QUOTES = CSSPatch.createAttribute("quotes", null, false);
    public static final CSS.Attribute RICHNESS = CSSPatch.createAttribute("richness", null, false);
    public static final CSS.Attribute RIGHT = CSSPatch.createAttribute("right", null, false);
    public static final CSS.Attribute SPEAK = CSSPatch.createAttribute("speak", null, false);
    public static final CSS.Attribute SPEAK_HEADER = CSSPatch.createAttribute("speak-header", null, false);
    public static final CSS.Attribute SPEAK_NUMERAL = CSSPatch.createAttribute("speak-numeral", null, false);
    public static final CSS.Attribute SPEAK_PUNCTUATION = CSSPatch.createAttribute("speak-punctuation", null, false);
    public static final CSS.Attribute SPEECH_RATE = CSSPatch.createAttribute("speech-rate", null, false);
    public static final CSS.Attribute STRESS = CSSPatch.createAttribute("stress", null, false);
    public static final CSS.Attribute TABLE_LAYOUT = CSSPatch.createAttribute("table-layout", null, false);
    public static final CSS.Attribute TOP = CSSPatch.createAttribute("top", null, false);
    public static final CSS.Attribute UNICODE_BIDI = CSSPatch.createAttribute("unicode-bidi", null, false);
    public static final CSS.Attribute VISIBILITY = CSSPatch.createAttribute("visibility", null, false);
    public static final CSS.Attribute VOICE_FAMILY = CSSPatch.createAttribute("voice-family", null, false);
    public static final CSS.Attribute VOLUME = CSSPatch.createAttribute("volume", null, false);
    public static final CSS.Attribute WIDOWS = CSSPatch.createAttribute("widows", null, false);
    public static final CSS.Attribute Z_INDEX = CSSPatch.createAttribute("z-index", null, false);

    static {
        try {
            CSSPatch.patchCSSClass();
        }
        catch (Throwable t) {
            LOG.error("Failed patching CSS class", t);
        }
    }

    private CSSPatch() {
    }

    public static void apply() {
    }

    private static void patchCSSClass() throws Throwable {
        CSS.Attribute key;
        CSS.Attribute[] additionalAttributes;
        CSS.Attribute[] attributeArray = additionalAttributes = new CSS.Attribute[]{AZIMUTH, BORDER_BOTTOM_COLOR, BORDER_BOTTOM_STYLE, BORDER_COLLAPSE, BORDER_LEFT_COLOR, BORDER_LEFT_STYLE, BORDER_RIGHT_COLOR, BORDER_RIGHT_STYLE, BORDER_SPACING, BORDER_TOP_COLOR, BORDER_TOP_STYLE, BOTTOM, CAPTION_SIDE, CLIP, CONTENT, COUNTER_INCREMENT, COUNTER_RESET, CUE, CUE_AFTER, CUE_BEFORE, CURSOR, DIRECTION, ELEVATION, EMPTY_CELLS, LEFT, MAX_HEIGHT, MAX_WIDTH, MIN_HEIGHT, MIN_WIDTH, ORPHANS, OUTLINE, OUTLINE_COLOR, OUTLINE_STYLE, OUTLINE_WIDTH, OVERFLOW, PAGE_BREAK_AFTER, PAGE_BREAK_BEFORE, PAGE_BREAK_INSIDE, PAUSE, PAUSE_AFTER, PAUSE_BEFORE, PITCH, PITCH_RANGE, PLAY_DURING, POSITION, QUOTES, RICHNESS, RIGHT, SPEAK, SPEAK_HEADER, SPEAK_NUMERAL, SPEAK_PUNCTUATION, SPEECH_RATE, STRESS, TABLE_LAYOUT, TOP, UNICODE_BIDI, VISIBILITY, VOICE_FAMILY, VOLUME, WIDOWS, Z_INDEX};
        int n = additionalAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            CSS.Attribute key2 = attributeArray[n2];
            if (key2 == null) {
                throw new Exception("Attribute is null");
            }
            ++n2;
        }
        Field f = CSS.Attribute.class.getDeclaredField("allAttributes");
        ReflectionUtility.removeFinalFlagOnField(f);
        f.setAccessible(true);
        CSS.Attribute[] allAttributes = (CSS.Attribute[])f.get(null);
        CSS.Attribute[] newArray = new CSS.Attribute[allAttributes.length + additionalAttributes.length];
        System.arraycopy(allAttributes, 0, newArray, 0, allAttributes.length);
        System.arraycopy(additionalAttributes, 0, newArray, allAttributes.length, additionalAttributes.length);
        f.set(null, newArray);
        f = CSS.class.getDeclaredField("attributeMap");
        f.setAccessible(true);
        Hashtable attributeMap = (Hashtable)f.get(null);
        CSS.Attribute[] attributeArray2 = additionalAttributes;
        int n3 = additionalAttributes.length;
        int n4 = 0;
        while (n4 < n3) {
            key = attributeArray2[n4];
            attributeMap.put(key.toString(), key);
            ++n4;
        }
        attributeArray2 = additionalAttributes;
        n3 = additionalAttributes.length;
        n4 = 0;
        while (n4 < n3) {
            key = attributeArray2[n4];
            try {
                StyleContext.registerStaticAttributeKey(key);
            }
            catch (Throwable t) {
                LOG.error("Failed registering CSS.Attribute '" + key + "' on StyleContext", t);
            }
            ++n4;
        }
    }

    private static CSS.Attribute createAttribute(String s1, String s2, boolean b) {
        try {
            Constructor c = CSS.Attribute.class.getDeclaredConstructor(String.class, String.class, Boolean.TYPE);
            c.setAccessible(true);
            return (CSS.Attribute)c.newInstance(s1, s2, b);
        }
        catch (Throwable t) {
            LOG.error("Failed patching CSS by adding key '" + s1 + "'", t);
            return null;
        }
    }

    private static Object createCssValue() throws Exception {
        Constructor<?> c = Class.forName(String.valueOf(CSS.class.getName()) + "$CssValue", true, CSS.class.getClassLoader()).getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        return c.newInstance(new Object[0]);
    }
}

