/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.IObjectSerializer;
import org.eclipse.scout.commons.serialization.SerializationUtility;

public final class CloneUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CloneUtility.class);

    private CloneUtility() {
    }

    public static <T> T createDeepCopyBySerializing(T obj) throws Exception {
        if (obj == null) {
            return null;
        }
        try {
            IObjectSerializer serializer = SerializationUtility.createObjectSerializer();
            byte[] serialData = serializer.serialize(obj);
            Class<?> expectedType = obj.getClass();
            Object copy = serializer.deserialize(serialData, expectedType);
            return (T)copy;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(ClassNotFoundException.class.getSimpleName()) + " occurred while creating a deep copy using " + SerializationUtility.class.getSimpleName() + ". Using fallback strategy.", e);
            }
            return CloneUtility.fallBackCreateDeepCopyBySerializing(obj);
        }
    }

    private static <T> T fallBackCreateDeepCopyBySerializing(T obj) throws Exception {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        DeepCopyObjectWriter oo = new DeepCopyObjectWriter(o);
        oo.writeObject(obj);
        oo.close();
        DeepCopyObjectReader oi = new DeepCopyObjectReader(new ByteArrayInputStream(o.toByteArray()), oo.getClassesByName());
        Object copy = oi.readObject();
        oi.close();
        Object castedCopy = copy;
        return (T)castedCopy;
    }

    private static class DeepCopyObjectReader
    extends ObjectInputStream {
        private final Map<String, Class<?>> m_classesByName;

        public DeepCopyObjectReader(InputStream in, Map<String, Class<?>> classesByName) throws IOException {
            super(in);
            this.m_classesByName = classesByName;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> c = this.m_classesByName.get(desc.getName());
            if (c != null) {
                return c;
            }
            return super.resolveClass(desc);
        }
    }

    private static class DeepCopyObjectWriter
    extends ObjectOutputStream {
        private final Map<String, Class<?>> m_classesByName = new HashMap();

        public DeepCopyObjectWriter(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> c) throws IOException {
            if (c != null) {
                this.m_classesByName.put(c.getName(), c);
            }
        }

        public Map<String, Class<?>> getClassesByName() {
            return this.m_classesByName;
        }
    }
}

