/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.logger.internal.eclipse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.EclipseLogUtility;
import org.eclipse.scout.commons.logger.IScoutLogManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.JavaLogUtility;
import org.eclipse.scout.commons.logger.internal.eclipse.EclipseLogWrapper;
import org.eclipse.scout.commons.logger.internal.java.JavaScoutLogManager;

public class EclipseScoutLogManager
implements IScoutLogManager {
    private Integer m_globalLogLevel;
    private P_LogListener m_logListener;
    private Object m_recordingLock = new Object();

    @Override
    public void initialize() {
    }

    @Override
    public void setGlobalLogLevel(Integer globalLogLevel) {
        this.m_globalLogLevel = globalLogLevel;
    }

    @Override
    public Integer getGlobalLogLevel() {
        return this.m_globalLogLevel;
    }

    @Override
    public IScoutLogger getLogger(String name) {
        return new EclipseLogWrapper(name, this.getSystemLogLevel());
    }

    @Override
    public IScoutLogger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startRecording() throws ProcessingException {
        Object object = this.m_recordingLock;
        synchronized (object) {
            block4: {
                if (this.m_logListener != null) break block4;
                this.m_logListener = new P_LogListener();
                Platform.addLogListener((ILogListener)this.m_logListener);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File stopRecording() {
        Object object = this.m_recordingLock;
        synchronized (object) {
            block4: {
                if (this.m_logListener != null) break block4;
                return null;
            }
            Platform.removeLogListener((ILogListener)this.m_logListener);
            File logFile = this.m_logListener.getLogFile();
            this.m_logListener = null;
            return logFile;
        }
    }

    private int getSystemLogLevel() {
        String levelText = StringUtility.uppercase(Activator.getDefault().getBundle().getBundleContext().getProperty("org.eclipse.scout.log.level"));
        if (!StringUtility.hasText(levelText)) {
            levelText = "WARNING";
        }
        if ("ERROR".equals(levelText)) {
            return 1;
        }
        if ("WARNING".equals(levelText)) {
            return 2;
        }
        if ("INFO".equals(levelText)) {
            return 3;
        }
        if ("DEBUG".equals(levelText)) {
            return 4;
        }
        return 2;
    }

    private final class P_LogListener
    implements ILogListener {
        private File m_logFile;
        private BufferedWriter m_logWriter;

        public P_LogListener() throws ProcessingException {
            try {
                this.m_logFile = IOUtility.createTempFile("log.log", null);
                this.m_logWriter = new BufferedWriter(new FileWriter(this.m_logFile));
            }
            catch (Exception e) {
                throw new ProcessingException("could not install log listener", e);
            }
        }

        public void logging(IStatus status, String plugin) {
            int severity = EclipseLogUtility.eclipseToScoutLevel(status.getSeverity());
            Level level = JavaLogUtility.scoutToJavaLevel(severity);
            String logLevel = "[" + level.getName() + "] ";
            String logPlugin = StringUtility.hasText(status.getPlugin()) ? "plug-In=" + status.getPlugin() : "plug-In=" + plugin;
            String logCode = null;
            if (status.getCode() != 0) {
                logCode = "code=" + status.getCode();
            }
            String log = StringUtility.join(" ", logLevel, this.getFormattedDate(), logPlugin, logCode, status.getMessage(), this.getStackTrace(status.getException()));
            try {
                this.m_logWriter.write(log);
                this.m_logWriter.newLine();
            }
            catch (IOException e) {
                System.err.println("Failed recording logging entry");
            }
        }

        public File getLogFile() {
            try {
                this.m_logWriter.flush();
                this.m_logWriter.close();
                return this.m_logFile;
            }
            catch (IOException e) {
                EclipseScoutLogManager.this.getLogger(JavaScoutLogManager.class).error("could not get log file", e);
                return null;
            }
        }

        private String getFormattedDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            return new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss").format(calendar.getTime());
        }

        private String getStackTrace(Throwable t) {
            if (t == null) {
                return null;
            }
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
    }
}

