/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.AbstractMemoryPolicy;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public class LargeMemoryPolicy
extends AbstractMemoryPolicy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LargeMemoryPolicy.class);
    private final Map<String, AbstractMemoryPolicy.SearchFormState> m_searchFormCache = new HashMap<String, AbstractMemoryPolicy.SearchFormState>();
    private final Map<String, Map<String, byte[]>> m_tableColumnFilterManagerState = new HashMap<String, Map<String, byte[]>>();

    @Override
    protected void loadSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
        AbstractMemoryPolicy.SearchFormState state = this.m_searchFormCache.get(pageFormIdentifier);
        if (state != null) {
            if (state.formContentXml != null) {
                f.setXML(state.formContentXml);
            }
            if (state.searchFilter != null) {
                f.setSearchFilter(state.searchFilter);
            }
        }
    }

    @Override
    protected void storeSearchFormState(IForm f, String pageFormIdentifier) throws ProcessingException {
        if (f.isEmpty()) {
            this.m_searchFormCache.remove(pageFormIdentifier);
        } else {
            String xml = f.getXML("UTF-8");
            SearchFilter filter = f.getSearchFilter();
            this.m_searchFormCache.put(pageFormIdentifier, new AbstractMemoryPolicy.SearchFormState(xml, filter));
        }
    }

    @Override
    protected void storeColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
        ITableColumnFilterManager filterManager = t.getColumnFilterManager();
        if (filterManager == null || filterManager.getFilters() == null || filterManager.getFilters().isEmpty()) {
            this.m_tableColumnFilterManagerState.remove(pageTableIdentifier);
            return;
        }
        Map<String, byte[]> state = this.m_tableColumnFilterManagerState.get(pageTableIdentifier);
        if (state == null) {
            state = new HashMap<String, byte[]>();
            this.m_tableColumnFilterManagerState.put(pageTableIdentifier, state);
        }
        for (ITableColumnFilter filter : filterManager.getFilters()) {
            IColumn col = filter.getColumn();
            if (col.getColumnId() == null) continue;
            byte[] data = filterManager.getSerializedFilter(col);
            if (data == null || data.length == 0) {
                state.remove(col.getColumnId());
                continue;
            }
            state.put(col.getColumnId(), data);
        }
    }

    @Override
    protected void loadColumnFilterState(ITable t, String pageTableIdentifier) throws ProcessingException {
        if (t == null || t.getColumnFilterManager() == null) {
            return;
        }
        Map<String, byte[]> state = this.m_tableColumnFilterManagerState.get(pageTableIdentifier);
        if (state != null) {
            for (Map.Entry<String, byte[]> entry : state.entrySet()) {
                Object col = t.getColumnSet().getColumnById(entry.getKey());
                if (col == null) continue;
                t.getColumnFilterManager().setSerializedFilter(entry.getValue(), (IColumn)col);
            }
        }
    }

    @Override
    public void afterOutlineSelectionChanged(final IDesktop desktop) {
        long memMax;
        long memTotal = Runtime.getRuntime().totalMemory();
        long memUsed = memTotal - Runtime.getRuntime().freeMemory();
        if (memUsed > (memMax = Runtime.getRuntime().maxMemory()) * 80L / 100L) {
            new ClientSyncJob("Check memory", ClientSyncJob.getCurrentSession()){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    desktop.releaseUnusedPages();
                    System.gc();
                }
            }.schedule();
        }
    }

    @Override
    public String toString() {
        return "Large";
    }
}

