/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.extension.client.internal.AbstractExtensionManager;
import org.eclipse.scout.rt.extension.client.internal.IExtensionProcessor;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.CompositePageFilter;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageModifier;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageAnchorFilter;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageContributionExtension;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageModificationExtension;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageRemoveExtension;
import org.osgi.framework.Bundle;

public class PageExtensionManager
extends AbstractExtensionManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageExtensionManager.class);
    public static final String EXTENSION_POINT_ID = "org.eclipse.scout.rt.extension.client.pages";
    public static final String PAGE_CONTRIBUTION_ELEMENT = "pageContribution";
    public static final String PAGE_REMOVAL_ELEMENT = "pageRemoval";
    public static final String PAGE_MODIFICATION_ELEMENT = "pageModification";
    private final List<PageContributionExtension> m_pageContributionExtensions = new LinkedList<PageContributionExtension>();
    private final List<PageRemoveExtension> m_pageRemoveExtensions = new LinkedList<PageRemoveExtension>();
    private final List<PageModificationExtension> m_pageModificationExtensions = new LinkedList<PageModificationExtension>();

    public PageExtensionManager(IExtensionRegistry extensionRegistry) {
        super(extensionRegistry, EXTENSION_POINT_ID);
        this.initExtensionProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageContributionExtension> getPageContributionExtensions() throws ProcessingException {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureStarted();
            return new LinkedList<PageContributionExtension>(this.m_pageContributionExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageRemoveExtension> getPageRemovalExtensions() throws ProcessingException {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureStarted();
            return new LinkedList<PageRemoveExtension>(this.m_pageRemoveExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageModificationExtension> getPageModificationExtensions() throws ProcessingException {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureStarted();
            return new LinkedList<PageModificationExtension>(this.m_pageModificationExtensions);
        }
    }

    private void initExtensionProcessors() {
        this.addExtensionProcessor(PAGE_CONTRIBUTION_ELEMENT, new IExtensionProcessor<PageContributionExtension>(){

            @Override
            public PageContributionExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Double order = (Double)TypeCastUtility.castValue((Object)element.getAttribute("order"), Double.class);
                Class<IPage> pageClass = PageExtensionManager.loadClass(contributor, IPage.class, element.getAttribute("class"));
                IPageExtensionFilter pageFilter = PageExtensionManager.this.parseAndCreatePageFilters(contributor, element);
                PageContributionExtension pageContribution = new PageContributionExtension(pageFilter, pageClass, (Double)NumberUtility.nvl((Object)order, (Object)1.23456789E8));
                PageExtensionManager.this.m_pageContributionExtensions.add(pageContribution);
                return pageContribution;
            }
        });
        this.addExtensionProcessor(PAGE_REMOVAL_ELEMENT, new IExtensionProcessor<PageRemoveExtension>(){

            @Override
            public PageRemoveExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IPage> pageClass = PageExtensionManager.loadClass(contributor, IPage.class, element.getAttribute("class"));
                IPageExtensionFilter pageFilter = PageExtensionManager.this.parseAndCreatePageFilters(contributor, element);
                PageRemoveExtension pageRemoveExtension = new PageRemoveExtension(pageFilter, pageClass);
                PageExtensionManager.this.m_pageRemoveExtensions.add(pageRemoveExtension);
                return pageRemoveExtension;
            }
        });
        this.addExtensionProcessor(PAGE_MODIFICATION_ELEMENT, new IExtensionProcessor<PageModificationExtension>(){

            @Override
            public PageModificationExtension processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IPage> pageClass = PageExtensionManager.loadClass(contributor, IPage.class, element.getAttribute("page"));
                Class<IPageModifier> modifierClass = PageExtensionManager.loadClass(contributor, IPageModifier.class, element.getAttribute("class"));
                if (modifierClass == null) {
                    return null;
                }
                IPageExtensionFilter pageFilter = PageExtensionManager.this.parseAndCreatePageFilters(contributor, element);
                PageModificationExtension pageModification = new PageModificationExtension(pageFilter, pageClass, modifierClass);
                PageExtensionManager.this.m_pageModificationExtensions.add(pageModification);
                return pageModification;
            }
        });
    }

    private IPageExtensionFilter parseAndCreatePageFilters(Bundle contributor, IConfigurationElement element) throws Exception {
        Class<IOutline> outlineFilterClass = null;
        Class<IPage> parentPageFilterClass = null;
        CompositePageFilter compositeFilter = new CompositePageFilter(new IPageExtensionFilter[0]);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if ("outline".equals(child.getName())) {
                outlineFilterClass = PageExtensionManager.loadClass(contributor, IOutline.class, child.getAttribute("class"));
            } else if ("parentPage".equals(child.getName())) {
                parentPageFilterClass = PageExtensionManager.loadClass(contributor, IPage.class, child.getAttribute("class"));
            } else if ("filter".equals(child.getName())) {
                try {
                    IPageExtensionFilter filter = (IPageExtensionFilter)child.createExecutableExtension("class");
                    compositeFilter.addFilter(filter);
                }
                catch (Exception e) {
                    LOG.error("Exception while creating filter class [" + element.getAttribute("class") + "]", (Throwable)e);
                }
            }
            ++n2;
        }
        PageAnchorFilter desktopAnchorFilter = null;
        if (outlineFilterClass != null || parentPageFilterClass != null) {
            desktopAnchorFilter = new PageAnchorFilter(outlineFilterClass, parentPageFilterClass);
            compositeFilter.addFilterAtBegin(desktopAnchorFilter);
        }
        if (!compositeFilter.isEmpty()) {
            return compositeFilter;
        }
        return null;
    }

    @Override
    protected void removeContributions(Set<Object> contributions) {
        this.m_pageContributionExtensions.removeAll(contributions);
        this.m_pageRemoveExtensions.removeAll(contributions);
        this.m_pageModificationExtensions.removeAll(contributions);
    }
}

