/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;

public class DropDownButtonIcon
implements Icon {
    private static final Map<IconGroup.IconState, Color> ARROW_COLOR_MAP = new HashMap<IconGroup.IconState, Color>();
    private final ISwingEnvironment m_env;
    private P_IconPart m_partIcon;
    private P_IconPart m_partArrow;
    private IconGroup m_iconGroup;

    public DropDownButtonIcon(ISwingEnvironment env) {
        ARROW_COLOR_MAP.put(IconGroup.IconState.NORMAL, UIManager.getColor("TextFieldArrow.normal"));
        ARROW_COLOR_MAP.put(IconGroup.IconState.DISABLED, UIManager.getColor("TextFieldArrow.disabled"));
        ARROW_COLOR_MAP.put(IconGroup.IconState.ROLLOVER, UIManager.getColor("TextFieldArrow.mouseOver"));
        this.m_partIcon = new P_IconPart();
        this.m_partArrow = new P_IconPart();
        this.m_iconGroup = new IconGroup();
        this.m_env = env;
        this.m_partArrow.setEnabled(false);
        this.m_partArrow.setVisible(false);
        this.m_iconGroup = new IconGroup(this.m_env, "smartfield_browse");
    }

    public void setIconGroup(IconGroup iconGroup) {
        this.m_iconGroup = iconGroup == null ? new IconGroup(this.m_env, "smartfield_browse") : iconGroup;
    }

    public boolean isArrowEnabled() {
        return this.m_partArrow.isEnabled();
    }

    public void setArrowEnabled(boolean enabled) {
        this.m_partArrow.setEnabled(enabled);
        this.m_partArrow.setVisible(enabled);
    }

    public boolean isIconEnabled() {
        return this.m_partIcon.isEnabled();
    }

    public void setIconEnabled(boolean enabled) {
        this.m_partIcon.setEnabled(enabled);
    }

    @Override
    public int getIconHeight() {
        return this.getIconForState().getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.getIconForState().getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconForState().paintIcon(c, g, x, y);
        this.paintArrow(c, g, x, y);
    }

    private Icon getIconForState() {
        return this.m_iconGroup.getIcon(this.m_partIcon.getIconState());
    }

    private void paintArrow(Component c, Graphics g, int x, int y) {
        if (!this.m_partArrow.isVisible()) {
            return;
        }
        int arrowHeight = 3;
        int maxArrowWidth = 5;
        int startAtX = x + this.getIconWidth() - maxArrowWidth;
        int startAtY = y + 2;
        g.setColor(ARROW_COLOR_MAP.get((Object)this.m_partArrow.getIconState()));
        int j = 0;
        while (j < arrowHeight) {
            int arrowWidth = this.calcArrowWidth(j);
            int ax = startAtX + j;
            int ay = startAtY + j;
            g.drawLine(ax, ay, ax + arrowWidth - 1, ay);
            ++j;
        }
    }

    private int calcArrowWidth(int line) {
        return 5 - line * 2;
    }

    public void setMouseOver(MouseOver mouseOver) {
        if (MouseOver.NONE == mouseOver) {
            this.m_partIcon.setMouseOver(false);
            this.m_partArrow.setMouseOver(false);
        } else if (MouseOver.ICON == mouseOver) {
            this.m_partIcon.setMouseOver(true);
            this.m_partArrow.setMouseOver(false);
        } else if (MouseOver.ARROW == mouseOver) {
            this.m_partIcon.setMouseOver(false);
            this.m_partArrow.setMouseOver(true);
        }
    }

    public static enum MouseOver {
        NONE,
        ICON,
        ARROW;

    }

    private class P_IconPart {
        private boolean m_visible = true;
        private boolean m_enabled = true;
        private boolean m_mouseOver = false;

        private P_IconPart() {
        }

        public boolean isVisible() {
            return this.m_visible;
        }

        public void setVisible(boolean visible) {
            this.m_visible = visible;
        }

        public IconGroup.IconState getIconState() {
            if (!this.m_enabled) {
                return IconGroup.IconState.DISABLED;
            }
            if (this.m_mouseOver) {
                return IconGroup.IconState.ROLLOVER;
            }
            return IconGroup.IconState.NORMAL;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public void setEnabled(boolean b) {
            this.m_enabled = b;
        }

        public boolean isMouseOver() {
            return this.m_mouseOver;
        }

        public void setMouseOver(boolean b) {
            this.m_mouseOver = b;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[enabled=" + this.m_enabled + " mouseOver=" + this.m_mouseOver + " visible=" + this.m_visible + "]";
        }
    }
}

