/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JCheckBoxEx
extends JCheckBox
implements FocusListener {
    private static final long serialVersionUID = 1L;

    public JCheckBoxEx() {
        this.addFocusListener(this);
        SwingUtility.installDefaultFocusHandling(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public void setMandatory(boolean mandatory) {
        Font f = this.getFont();
        if (f != null && f.getStyle() == 1 != mandatory) {
            f = new Font(f.getName(), mandatory ? 1 : 0, f.getSize());
        }
        this.setFont(f);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }

    @Override
    public void setText(String text) {
        if (SwingUtility.isMultilineLabelText(text)) {
            this.setVerticalTextPosition(1);
            text = SwingUtility.createHtmlLabelText(text, false);
        } else {
            this.setVerticalTextPosition(0);
        }
        super.setText(text);
    }
}

