/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.NumberUtility;

public class ActivityMapSelection {
    private TreeSet<Integer> m_rows = new TreeSet();
    private double[] m_range;
    private boolean m_extend = true;
    private boolean m_hasAnchor;
    private int m_anchorRow;
    private double[] m_anchorRange;
    private boolean m_hasLead;
    private int m_leadRow;
    private double[] m_leadRange;

    public ActivityMapSelection() {
        this.clear();
    }

    public ActivityMapSelection(ActivityMapSelection s) {
        this.m_rows = new TreeSet<Integer>((SortedSet<Integer>)s.m_rows);
        this.m_range = s.m_range;
        this.m_hasAnchor = s.m_hasAnchor;
        this.m_anchorRow = s.m_anchorRow;
        if (s.m_anchorRange != null) {
            this.m_anchorRange = new double[]{s.m_anchorRange[0], s.m_anchorRange[1]};
        }
        this.m_hasLead = s.m_hasLead;
        this.m_leadRow = s.m_leadRow;
        if (s.m_leadRange != null) {
            this.m_leadRange = new double[]{s.m_leadRange[0], s.m_leadRange[1]};
        }
        this.m_extend = s.m_extend;
    }

    public double[] getRange() {
        if (this.m_hasAnchor && this.m_hasLead && this.m_extend) {
            if (this.m_range != null) {
                return new double[]{NumberUtility.min((double[])new double[]{this.m_range[0], this.m_anchorRange[0], this.m_leadRange[0]}), NumberUtility.max((double[])new double[]{this.m_range[1], this.m_anchorRange[1], this.m_leadRange[1]})};
            }
            return new double[]{NumberUtility.min((double[])new double[]{this.m_anchorRange[0], this.m_leadRange[0]}), NumberUtility.max((double[])new double[]{this.m_anchorRange[1], this.m_leadRange[1]})};
        }
        return this.m_range;
    }

    public void setRange(double[] newRange) {
        if (newRange != null && newRange[1] - newRange[0] < 0.0) {
            newRange = new double[]{newRange[1], newRange[0]};
        }
        if (!CompareUtility.equals((Object)this.m_range, (Object)newRange)) {
            this.m_range = newRange;
        }
    }

    public int[] getRows() {
        TreeSet<Integer> set = new TreeSet<Integer>((SortedSet<Integer>)this.m_rows);
        if (this.m_hasAnchor && this.m_hasLead) {
            int a = Math.min(this.m_anchorRow, this.m_leadRow);
            int b = Math.max(this.m_anchorRow, this.m_leadRow);
            int i = a;
            while (i <= b) {
                if (this.m_extend) {
                    set.add(i);
                } else {
                    set.remove(i);
                }
                ++i;
            }
        }
        int[] r = new int[set.size()];
        int i = 0;
        for (Integer n : set) {
            r[i++] = n;
        }
        return r;
    }

    public void setRows(int[] newRows) {
        this.m_rows = new TreeSet();
        if (newRows != null) {
            int i = 0;
            while (i < newRows.length) {
                this.m_rows.add(newRows[i]);
                ++i;
            }
        }
    }

    public void clear() {
        this.m_rows = new TreeSet();
        this.m_range = null;
        this.m_hasAnchor = false;
        this.m_anchorRow = -1;
        this.m_anchorRange = null;
        this.m_hasLead = false;
        this.m_leadRow = -1;
        this.m_leadRange = null;
    }

    public boolean hasAnchor() {
        return this.m_hasAnchor;
    }

    public boolean hasLead() {
        return this.m_hasLead;
    }

    public void setAnchor(int row, double[] range) {
        if (row >= 0) {
            this.m_extend = true;
            if (this.m_rows.contains(row) && this.intersects(this.m_range, range)) {
                this.m_extend = false;
            }
            this.m_hasAnchor = true;
            this.m_anchorRow = row;
            this.m_anchorRange = range;
        }
    }

    public void clearAnchor() {
        this.m_hasAnchor = false;
    }

    public void setLead(int row, double[] range) {
        if (row >= 0) {
            this.m_hasLead = true;
            this.m_leadRow = row;
            this.m_leadRange = range;
        }
    }

    public void clearLead() {
        this.m_hasLead = false;
    }

    public void consumeAnchorLead() {
        if (this.m_hasAnchor && this.m_hasLead) {
            this.setRows(this.getRows());
            this.setRange(this.getRange());
        }
        if (this.m_hasLead) {
            this.m_hasAnchor = this.m_hasLead;
            this.m_anchorRow = this.m_leadRow;
            this.m_anchorRange = this.m_leadRange;
            this.m_hasLead = false;
            this.m_leadRow = -1;
            this.m_leadRange = null;
        }
    }

    public boolean contains(int row, double[] range) {
        if (this.intersects(this.getRange(), range)) {
            int[] nArray = this.getRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int r = nArray[n2];
                if (r == row) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean intersects(double[] a, double[] b) {
        double end;
        if (a == null || b == null) {
            return false;
        }
        double start = Math.max(a[0], b[0]);
        return start < (end = Math.min(a[1], b[1]));
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivityMapSelection) {
            ActivityMapSelection o = (ActivityMapSelection)obj;
            return CompareUtility.equals(this.m_rows, o.m_rows) && CompareUtility.equals((Object)this.m_range, (Object)o.m_range) && this.m_hasAnchor == o.m_hasAnchor && CompareUtility.equals((Object)this.m_anchorRange, (Object)o.m_anchorRange) && this.m_anchorRow == o.m_anchorRow && this.m_hasLead == o.m_hasAnchor && CompareUtility.equals((Object)this.m_leadRange, (Object)o.m_leadRange) && this.m_leadRow == o.m_leadRow;
        }
        return false;
    }
}

