/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields;

import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;

public final class LogicalGridDataBuilder {
    public static final int FIELD_GRID_X = 1;
    public static final int FIELD_GRID_Y = 1;

    private LogicalGridDataBuilder() {
    }

    public static LogicalGridData createLabel(ISwingEnvironment env, GridData correspondingFieldData) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 0;
        data.gridy = 1;
        data.gridh = correspondingFieldData.h;
        data.weighty = 1.0;
        data.widthHint = env.getFieldLabelWidth();
        data.topInset = SwingLayoutUtility.getTextFieldTopInset();
        data.useUiWidth = true;
        data.useUiHeight = true;
        data.fillVertical = false;
        return data;
    }

    public static LogicalGridData createLabelOnTop(GridData correspondingFieldData) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 1;
        data.gridy = 0;
        data.weighty = 0.0;
        data.weightx = 1.0;
        data.useUiWidth = true;
        data.useUiHeight = true;
        data.fillVertical = true;
        data.fillHorizontal = true;
        return data;
    }

    public static LogicalGridData createField(ISwingEnvironment env, GridData correspondingFieldData) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 1;
        data.gridy = 1;
        data.weightx = 1.0;
        data.gridh = correspondingFieldData.h;
        data.weighty = correspondingFieldData.weightY == 0.0 || correspondingFieldData.weightY < 0.0 && correspondingFieldData.h <= 1 ? 0.0 : 1.0;
        data.useUiWidth = correspondingFieldData.useUiWidth;
        data.useUiHeight = correspondingFieldData.useUiHeight;
        return data;
    }

    public static LogicalGridData createButton1(ISwingEnvironment env) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 2;
        data.gridy = 1;
        data.fillVertical = false;
        data.useUiWidth = true;
        data.useUiHeight = true;
        return data;
    }

    public static LogicalGridData createButton2(ISwingEnvironment env) {
        LogicalGridData data = new LogicalGridData();
        data.gridx = 3;
        data.gridy = 1;
        data.useUiWidth = true;
        data.useUiHeight = true;
        data.fillVertical = false;
        return data;
    }
}

