/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.handler.internal;

import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.handler.internal.IScoutTransactionHandlerWrapper;
import org.eclipse.scout.jaxws.internal.ScoutTransactionDelegate;

public class ScoutTransactionLogicalHandlerWrapper<T extends LogicalMessageContext>
implements LogicalHandler<T>,
IScoutTransactionHandlerWrapper<T> {
    protected final ScoutTransactionDelegate m_transactionDelegate;
    protected final LogicalHandler<T> m_logicalHandler;

    public ScoutTransactionLogicalHandlerWrapper(LogicalHandler<T> logicalHandler, ScoutTransaction scoutTransaction) {
        this.m_transactionDelegate = this.createTransactionDelegate(scoutTransaction);
        this.m_logicalHandler = logicalHandler;
    }

    public boolean handleMessage(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionLogicalHandlerWrapper.this.m_logicalHandler.handleMessage((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public boolean handleFault(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionLogicalHandlerWrapper.this.m_logicalHandler.handleFault((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public void close(final MessageContext context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                ScoutTransactionLogicalHandlerWrapper.this.m_logicalHandler.close(context);
                return null;
            }
        };
        this.m_transactionDelegate.runInTransaction(runnable, context);
    }

    protected ScoutTransactionDelegate createTransactionDelegate(ScoutTransaction scoutTransaction) {
        return new ScoutTransactionDelegate(scoutTransaction);
    }

    @Override
    public Handler<T> getHandler() {
        return null;
    }
}

