/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class RemoteFileService
extends AbstractService
implements IRemoteFileService {
    private String m_rootPath;
    private static final Pattern LOCALE_SECURITY_PATTERN = Pattern.compile("[a-z]+([_][a-z0-9]+)?([_][a-z0-9_]+)?", 2);

    public RemoteFileService() throws ProcessingException {
        this.initConfig();
    }

    @ConfigProperty(value="STRING")
    protected String getConfiguredRootPath() {
        return null;
    }

    protected void initConfig() throws ProcessingException {
        this.setRootPath(this.getConfiguredRootPath());
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public void setRootPath(String rootPath) throws ProcessingException {
        if (rootPath == null || rootPath.length() == 0) {
            this.m_rootPath = null;
        } else {
            String tmp = BundleContextUtility.resolve((String)rootPath);
            tmp = tmp.replaceAll("\\\\", "/");
            tmp = tmp.replaceAll("//", "/");
            File f = new File(tmp);
            try {
                this.m_rootPath = f.getCanonicalPath();
            }
            catch (IOException e) {
                this.m_rootPath = null;
                throw new ProcessingException("invalid path for file service: '" + rootPath + "'", (Throwable)e);
            }
        }
    }

    public RemoteFile getRemoteFileHeader(RemoteFile spec) throws ProcessingException {
        return this.getRemoteFileInternal(spec, false, 0L, -1L);
    }

    public RemoteFile getRemoteFile(RemoteFile spec) throws ProcessingException {
        return this.getRemoteFileInternal(spec, null, 0L, -1L);
    }

    public RemoteFile getRemoteFile(RemoteFile spec, long maxBlockSize) throws ProcessingException {
        return this.getRemoteFileInternal(spec, null, 0L, maxBlockSize);
    }

    public RemoteFile getRemoteFilePart(RemoteFile spec, long blockNumber) throws ProcessingException {
        return this.getRemoteFileInternal(spec, null, blockNumber * 20000000L, 20000000L);
    }

    private RemoteFile getRemoteFileInternal(RemoteFile spec, Boolean includeContent, long startPosition, long maxBlockSize) throws ProcessingException {
        if (this.m_rootPath == null) {
            throw new SecurityException("invalid path for file service: path may not be null");
        }
        File file = this.getFileInternal(spec);
        RemoteFile result = new RemoteFile(spec.getDirectory(), file.getName(), spec.getLocale(), -1L, spec.getCharsetName());
        result.setContentType(spec.getContentType());
        if (!StringUtility.hasText((CharSequence)result.getContentType())) {
            int pos = result.getName().lastIndexOf(46);
            String ext = "";
            if (pos >= 0) {
                ext = result.getName().substring(pos + 1);
            }
            result.setContentTypeByExtension(ext);
        }
        if (file.exists()) {
            result.setExists(true);
            result.setLastModified(file.lastModified());
            long partLength = file.length();
            if (maxBlockSize > -1L && partLength > maxBlockSize) {
                if ((partLength -= startPosition) > maxBlockSize) {
                    partLength = maxBlockSize;
                }
                if (partLength <= 0L) {
                    partLength = 0L;
                }
            }
            result.setContentLength((int)partLength);
            if (!(includeContent != null && !includeContent.booleanValue() || CompareUtility.equals((Object)spec.getName(), (Object)result.getName()) && result.getLastModified() <= spec.getLastModified() && result.getPartStartPosition() == spec.getPartStartPosition())) {
                try {
                    result.readData((InputStream)new FileInputStream(file), startPosition, maxBlockSize);
                }
                catch (IOException e) {
                    throw new ProcessingException("error reading file: " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private String[][] getFiles(String folderBase, FilenameFilter filter) throws ProcessingException {
        String canonicalRoot;
        String canonicalFolder;
        if (this.m_rootPath == null) {
            throw new SecurityException("invalid path for file service: path may not be null");
        }
        File root = new File(this.getRootPath());
        File path = null;
        if (folderBase == null || folderBase.length() == 0) {
            path = new File(this.getRootPath());
        } else {
            String tmp = folderBase;
            tmp = tmp.replaceAll("\\\\", "/");
            tmp = tmp.replaceAll("//", "/");
            path = new File(this.getRootPath(), tmp);
        }
        try {
            canonicalFolder = path.getCanonicalPath();
            canonicalRoot = root.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ProcessingException("invalid path for file service for file: '" + folderBase + "'", (Throwable)e);
        }
        if (canonicalFolder == null || !canonicalFolder.startsWith(canonicalRoot)) {
            throw new SecurityException("invalid path for file service: path outside root-path");
        }
        ArrayList<String> dirList = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        String[] dir = path.list(filter);
        if (dir != null) {
            int i = 0;
            while (i < dir.length) {
                try {
                    File file = new File(String.valueOf(path.getCanonicalPath()) + "/" + dir[i]);
                    if (!file.isHidden()) {
                        if (file.exists() && file.isDirectory()) {
                            String[][] tmp;
                            String[][] stringArray = tmp = this.getFiles(folderBase == null ? dir[i] : String.valueOf(folderBase) + "/" + dir[i], filter);
                            int n = tmp.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] f = stringArray[n2];
                                dirList.add(f[0]);
                                fileList.add(f[1]);
                                ++n2;
                            }
                        } else {
                            dirList.add(folderBase);
                            fileList.add(dir[i]);
                        }
                    }
                }
                catch (IOException e) {
                    throw new ProcessingException("FileService.getFiles:", (Throwable)e);
                }
                ++i;
            }
        }
        String[][] retVal = new String[dirList.size()][2];
        int i = 0;
        while (i < dirList.size()) {
            retVal[i][0] = (String)dirList.get(i);
            retVal[i][1] = (String)fileList.get(i);
            ++i;
        }
        return retVal;
    }

    public RemoteFile[] getRemoteFiles(String folderPath, FilenameFilter filter, RemoteFile[] existingFileInfoOnClient) throws ProcessingException {
        return this.getRemoteFiles(folderPath, filter, existingFileInfoOnClient, "UTF-8");
    }

    public RemoteFile[] getRemoteFiles(String folderPath, FilenameFilter filter, RemoteFile[] existingFileInfoOnClient, String charsetName) throws ProcessingException {
        return this.getRemoteFiles(folderPath, filter, existingFileInfoOnClient, charsetName, 20000000L);
    }

    public RemoteFile[] getRemoteFiles(String folderPath, FilenameFilter filter, RemoteFile[] existingFileInfoOnClient, String charsetName, long maxBlockSize) throws ProcessingException {
        int n;
        HashMap<String, RemoteFile> fileList = new HashMap<String, RemoteFile>();
        if (existingFileInfoOnClient != null) {
            RemoteFile[] remoteFileArray = existingFileInfoOnClient;
            n = existingFileInfoOnClient.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteFile rf = remoteFileArray[n2];
                fileList.put(String.valueOf(rf.getDirectory().endsWith("/") ? rf.getDirectory() : String.valueOf(rf.getDirectory()) + "/") + rf.getName(), rf);
                ++n2;
            }
        }
        String[][] files = this.getFiles(folderPath, filter);
        String[][] stringArray = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            String[] file = stringArray[n];
            if (!fileList.containsKey(String.valueOf(file[0].endsWith("/") ? file[0] : String.valueOf(file[0]) + "/") + file[1])) {
                fileList.put(String.valueOf(file[0].endsWith("/") ? file[0] : String.valueOf(file[0]) + "/") + file[1], new RemoteFile(file[0], file[1], 0L, charsetName));
            }
            ++n;
        }
        RemoteFile[] retVal = new RemoteFile[fileList.size()];
        int i = 0;
        for (RemoteFile rf : fileList.values()) {
            retVal[i] = this.getRemoteFile(rf, maxBlockSize);
            ++i;
        }
        return retVal;
    }

    @RemoteServiceAccessDenied
    public void putRemoteFile(RemoteFile spec) throws ProcessingException {
        File file = this.getFileInternal(spec);
        try {
            file.getParentFile().mkdirs();
            spec.writeData((OutputStream)new FileOutputStream(file));
            file.setLastModified(file.lastModified());
        }
        catch (Exception e) {
            throw new ProcessingException("error writing file: " + file.getAbsoluteFile(), (Throwable)e);
        }
    }

    private File getFileInternal(RemoteFile spec) throws ProcessingException {
        String canonicalSimpleName;
        String canonicalFolder;
        String canonicalRoot;
        File root = new File(this.getRootPath());
        File folder = null;
        if (spec.getDirectory() == null || spec.getDirectory().length() == 0) {
            folder = new File(this.getRootPath());
        } else {
            String tmp = spec.getDirectory();
            tmp = tmp.replaceAll("\\\\", "/");
            tmp = tmp.replaceAll("//", "/");
            folder = new File(this.getRootPath(), tmp);
        }
        try {
            canonicalRoot = root.getCanonicalPath();
            canonicalFolder = folder.getCanonicalPath();
            canonicalSimpleName = new File(canonicalFolder, spec.getName()).getName();
        }
        catch (IOException e) {
            throw new ProcessingException("invalid or unaccessible path", (Throwable)e);
        }
        if (canonicalFolder == null || !canonicalFolder.startsWith(canonicalRoot)) {
            throw new SecurityException("invalid or unaccessible path");
        }
        if (canonicalSimpleName == null || !canonicalSimpleName.equals(spec.getName().startsWith("/") ? spec.getName().substring(1) : spec.getName())) {
            throw new SecurityException("invalid or unaccessible path");
        }
        String filename = canonicalSimpleName;
        if (spec.getLocale() != null && filename.lastIndexOf(46) != -1) {
            String localeText = spec.getLocale().toString().replaceAll("__", "_");
            if (!LOCALE_SECURITY_PATTERN.matcher(localeText).matches()) {
                throw new SecurityException("invalid or unaccessible path");
            }
            String[] checkedLocaleParts = localeText.split("_", 3);
            String prefix = filename.substring(0, filename.lastIndexOf(46));
            String suffix = filename.substring(filename.lastIndexOf(46));
            int i = checkedLocaleParts.length - 1;
            while (i >= 0) {
                if (prefix.toLowerCase().endsWith(checkedLocaleParts[i].toLowerCase()) && (prefix = prefix.substring(0, prefix.length() - checkedLocaleParts[i].length())).endsWith("_")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                --i;
            }
            if (!prefix.endsWith("_")) {
                prefix = String.valueOf(prefix) + "_";
            }
            filename = String.valueOf(prefix) + localeText + suffix;
            File test = new File(canonicalFolder, filename);
            while (!test.exists()) {
                if (localeText.indexOf(95) == -1) {
                    filename = canonicalSimpleName;
                    break;
                }
                localeText = localeText.substring(0, localeText.lastIndexOf(95));
                filename = String.valueOf(prefix) + localeText + suffix;
                test = new File(canonicalFolder, filename);
            }
        }
        File file = new File(canonicalFolder, filename);
        return file;
    }

    public void streamRemoteFile(RemoteFile spec, OutputStream out) throws ProcessingException {
        if (this.m_rootPath == null) {
            throw new SecurityException("invalid path for file service: path may not be null");
        }
        File file = this.getFileInternal(spec);
        if (!file.exists()) {
            throw new ProcessingException("remote file does not exist: " + spec.getPath());
        }
        try {
            int len = (int)file.length();
            byte[] buf = new byte[Math.min(102400, len)];
            int written = 0;
            int delta = 0;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                while (written < len) {
                    delta = in.read(buf);
                    out.write(buf, 0, delta);
                    written += delta;
                }
            }
        }
        catch (IOException e) {
            throw new ProcessingException("error streaming file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }
}

