/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.eclipse.scout.commons.CompressedObjectWriter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.jdbc.ISelectStreamHandler;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;

public class ByteArrayRowVisitor
implements ISelectStreamHandler {
    private static final long serialVersionUID = 1L;
    private static final int INITIAL_BUFFER_SIZE = 0x100000;
    private static final int DEFLATER_BUFFER_SIZE = 10240;
    private CompressedObjectWriter out = new CompressedObjectWriter(0x100000, 10240);

    @Override
    public void handleRow(Connection con, PreparedStatement stm, ResultSet rs, int rowIndex, List<SqlBind> values) throws ProcessingException {
        Object[] row = new Object[values.size()];
        int i = 0;
        while (i < row.length) {
            row[i] = values.get(i).getValue();
            ++i;
        }
        this.out.compress((Object)row);
        this.out.resetWrittenObjectCache();
    }

    @Override
    public void finished(Connection con, PreparedStatement stm, ResultSet rs, int rowCount) throws ProcessingException {
    }

    public byte[] getBytes() throws ProcessingException {
        return this.out.getCompressedBytes();
    }

    public void close() {
        this.out.close();
    }
}

