/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.services;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.TierState;
import org.eclipse.scout.service.CreateServiceImmediatelySchedulingRule;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IServiceFactory;
import org.eclipse.scout.service.ServiceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public abstract class CommonProxyServiceFactory<T extends ISession>
implements IServiceFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CommonProxyServiceFactory.class);
    private Bundle m_bundle;
    private final Class<?> m_serviceClass;
    private String m_sessionType;
    private Class<T> m_sessionClass;
    private Object m_serviceImpl;
    private final Object m_serviceLock = new Object();

    public CommonProxyServiceFactory(Class<?> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("service type must not be null");
        }
        this.m_serviceClass = serviceClass;
    }

    public void serviceRegistered(final ServiceRegistration registration) throws Throwable {
        Boolean createImmediately;
        if (!this.m_serviceClass.isInterface() && (createImmediately = (Boolean)registration.getReference().getProperty("service.createImmediately")) != null && createImmediately.booleanValue()) {
            Job job = new Job("create service " + this.m_serviceClass.getSimpleName()){

                protected IStatus run(IProgressMonitor monitor) {
                    CommonProxyServiceFactory.this.updateClassCache(registration);
                    CommonProxyServiceFactory.this.updateInstanceCache(registration);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)new CreateServiceImmediatelySchedulingRule());
            job.schedule();
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.updateClassCache(registration);
        if (this.isCreateServiceTunnelPossible() && (TierState.get() == this.getTier() || TierState.get() == TierState.Tier.Undefined)) {
            this.updateInstanceCache(registration);
            if (this.m_serviceClass.isInterface()) {
                Object service = ServiceTunnelUtility.createProxy(this.m_serviceClass, this.createServiceTunnel());
                return service;
            }
            return this.m_serviceImpl;
        }
        return ServiceUtility.NULL_SERVICE;
    }

    protected abstract TierState.Tier getTier();

    protected abstract Class<T> getDefaultSessionClass();

    protected abstract boolean isCreateServiceTunnelPossible();

    protected abstract IServiceTunnel createServiceTunnel();

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_bundle == null) {
                this.m_bundle = registration.getReference().getBundle();
            }
            if (this.m_sessionType == null) {
                this.m_sessionType = (String)registration.getReference().getProperty("service.sessionScope");
            }
            try {
                Class<T> defaultSessionClass = this.getDefaultSessionClass();
                if (this.m_sessionClass == null) {
                    if (this.m_sessionType == null) {
                        this.m_sessionClass = defaultSessionClass;
                    } else {
                        this.m_sessionClass = this.m_bundle.loadClass(this.m_sessionType);
                        if (!defaultSessionClass.isAssignableFrom(this.m_sessionClass)) {
                            throw new IllegalArgumentException("session type must be a subtype of " + defaultSessionClass + ": " + this.m_sessionType);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Failed creating proxy class for " + this.m_serviceClass, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstanceCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_serviceImpl == null) {
                try {
                    if (!this.m_serviceClass.isInterface()) {
                        this.m_serviceImpl = this.createServiceInstance(this.m_serviceClass);
                        if (this.m_serviceImpl instanceof IService) {
                            ((IService)this.m_serviceImpl).initializeService(registration);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed creating proxy instance for " + this.m_serviceClass, t);
                }
            }
        }
    }

    protected final Class<T> getSessionClass() {
        return this.m_sessionClass;
    }

    protected Object createServiceInstance(Class<?> serviceClass) throws InstantiationException, IllegalAccessException {
        return serviceClass.newInstance();
    }
}

