/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.scout.sdk.core.util.IWeakEventListener;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.NlsType;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.PlatformTranslationFile;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.WorkspaceTranslationFile;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model.TranslationFileNewModel;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.ui.TranslationFileNewDialog;
import org.eclipse.scout.sdk.s2e.nls.model.INewLanguageContext;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.project.AbstractNlsProject;
import org.eclipse.scout.sdk.s2e.nls.project.NlsProjectEvent;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResource;
import org.eclipse.scout.sdk.s2e.operation.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Shell;

public class SimpleNlsProject
extends AbstractNlsProject {
    private NlsType m_nlsClass;
    private PropertyChangeListener m_nlsClassPropertyListener = new P_NlsClassPropertyChangeListener();

    public SimpleNlsProject(NlsType type) {
        super(type.getType());
        this.m_nlsClass = type;
        this.getNlsType().addPropertyChangeListener(this.m_nlsClassPropertyListener);
        this.updateTranslationResourceLocation();
        this.setSuperType(this.m_nlsClass.getSuperType());
    }

    @Override
    protected List<ITranslationResource> loadTranslationResources() throws CoreException {
        if (this.getNlsType().getType().isReadOnly()) {
            IPackageFragmentRoot r = (IPackageFragmentRoot)this.getNlsType().getType().getAncestor(3);
            if (r == null) {
                SdkLog.warning((String)"Could not find text resource for type '{}'.", (Object[])new Object[]{this.getNlsType().getType().getFullyQualifiedName()});
                return new ArrayList<ITranslationResource>(0);
            }
            return SimpleNlsProject.loadTranslationFilesFromPlatform(this.getNlsType(), r);
        }
        return SimpleNlsProject.loadTranslationFilesWorkspace(this.getNlsType());
    }

    private static List<ITranslationResource> loadTranslationFilesWorkspace(NlsType nlsType) throws CoreException {
        ArrayList<ITranslationResource> translationFiles = new ArrayList<ITranslationResource>();
        if (nlsType != null && S2eUtils.exists((IJavaElement)nlsType.getType()) && nlsType.getTranslationsFolderName() != null && nlsType.getTranslationsPrefix() != null) {
            Path translationPath = new Path(nlsType.getTranslationsFolderName());
            for (IFile file : SimpleNlsProject.getAllTranslations(nlsType.getType().getJavaProject().getProject(), (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                translationFiles.add(new WorkspaceTranslationFile(file));
            }
        }
        return translationFiles;
    }

    private static List<ITranslationResource> loadTranslationFilesFromPlatform(NlsType nlsType, IPackageFragmentRoot r) throws CoreException {
        IPackageFragment textFolder;
        String d;
        ArrayList<ITranslationResource> translationFiles = new ArrayList<ITranslationResource>();
        char delim = '.';
        String path = nlsType.getTranslationsFolderName().replace('/', delim);
        if (path.startsWith(d = "" + delim)) {
            path = path.substring(d.length());
        }
        if ((textFolder = r.getPackageFragment(path)) == null) {
            SdkLog.warning((String)"Folder '{}' could not be found in '{}'. Will be ignored.", (Object[])new Object[]{nlsType.getTranslationsFolderName(), r.getElementName()});
        } else {
            Object[] objectArray = textFolder.getNonJavaResources();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof JarEntryFile) {
                    JarEntryFile f = (JarEntryFile)o;
                    try {
                        Throwable throwable = null;
                        Object var13_15 = null;
                        try (InputStream is = f.getContents();){
                            translationFiles.add(new PlatformTranslationFile(is, SimpleNlsProject.getLanguage(f.getName())));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        SdkLog.error((String)"Could not load NLS files of entry '{}'.", (Object[])new Object[]{r.getElementName(), e});
                    }
                }
                ++n2;
            }
        }
        return translationFiles;
    }

    private void createTranslationFile(Language language, IFolder folder, IProgressMonitor monitor) throws CoreException {
        String fileName = SimpleNlsProject.getLocalizedPropertiesFileName(this.getNlsType().getTranslationsPrefix(), language);
        IFile file = folder.getFile((IPath)new Path(fileName));
        if (!file.exists()) {
            S2eUtils.writeResources(Collections.singletonList(new ResourceWriteOperation(file, "")), (IProgressMonitor)monitor, (boolean)true);
        }
        this.addTranslationResource(new WorkspaceTranslationFile(file));
    }

    @Override
    public INewLanguageContext getTranslationCreationContext() {
        return new INewLanguageContext(){
            private final TranslationFileNewModel m_model;
            {
                this.m_model = new TranslationFileNewModel(SimpleNlsProject.this);
            }

            @Override
            public boolean interactWithUi(Shell s) {
                TranslationFileNewDialog dialog = new TranslationFileNewDialog(s, this.m_model);
                return dialog.open() == 0;
            }

            @Override
            public void execute(IProgressMonitor monitor) {
                try {
                    SimpleNlsProject.this.createTranslationFile(this.m_model.getLanguage(), this.m_model.getFolder(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    SdkLog.error((String)"Unable to create new language.", (Object[])new Object[]{e});
                }
            }

            @Override
            public Object getModel() {
                return this.m_model;
            }
        };
    }

    private void setSuperType(IType superType) {
        if (superType != null) {
            try {
                this.setParent(NlsCore.getNlsWorkspace().getNlsProject(new Object[]{superType}));
            }
            catch (CoreException e) {
                SdkLog.error((String)"parent of NLS project could not be found. Looked for type '{}'.", (Object[])new Object[]{superType.getFullyQualifiedName(), e});
            }
        }
    }

    public NlsType getNlsType() {
        return this.m_nlsClass;
    }

    public static List<IFile> getAllTranslations(IProject toLookAt, IPath path, String fileNamePrefix) throws CoreException {
        return SimpleNlsProject.getAllTranslations(SimpleNlsProject.getFoldersOfProject(toLookAt, path), fileNamePrefix);
    }

    public static List<IFolder> getFoldersOfProject(IProject project, IPath path) throws CoreException {
        if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return Collections.emptyList();
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null || !jp.exists()) {
            return Collections.emptyList();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] clEntries = jp.getRawClasspath();
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        IClasspathEntry[] iClasspathEntryArray = clEntries;
        int n = clEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath toCheck;
            IFolder folder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (folder = root.getFolder(toCheck = entry.getPath().append(path))) != null && folder.exists()) {
                folders.add(folder);
            }
            ++n2;
        }
        IFolder foundFolder = project.getFolder(path);
        if (foundFolder != null && foundFolder.exists()) {
            folders.add(foundFolder);
        }
        return folders;
    }

    public static List<IFile> getAllTranslations(List<IFolder> folders, String fileNamePrefix) throws CoreException {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (IFolder folder : folders) {
            IResource[] resources;
            if (!folder.exists()) continue;
            IResource[] iResourceArray = resources = folder.members(0);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getName().matches(String.valueOf(fileNamePrefix) + "(_[a-zA-Z]{2}){0,3}" + "\\.properties")) {
                    files.add((IFile)resource);
                }
                ++n2;
            }
        }
        return files;
    }

    public static Language getLanguage(String simpleFileName) {
        Matcher matcher = Pattern.compile("^[^_.]*(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?\\.properties$").matcher(simpleFileName);
        if (matcher.matches()) {
            String variantIso;
            String countryIso;
            if (matcher.group(2) == null) {
                return Language.LANGUAGE_DEFAULT;
            }
            String languageIso = matcher.group(2);
            if (languageIso == null) {
                languageIso = "";
            }
            if ((countryIso = matcher.group(4)) == null) {
                countryIso = "";
            }
            if ((variantIso = matcher.group(5)) == null) {
                variantIso = "";
            }
            return new Language(new Locale(languageIso, countryIso, variantIso));
        }
        return null;
    }

    public static String getLocalizedPropertiesFileName(String prefix, Language language) {
        String fileName = prefix;
        Locale locale = language.getLocale();
        fileName = String.valueOf(fileName) + "_" + locale.toString() + ".properties";
        return fileName;
    }

    private class P_NlsClassPropertyChangeListener
    implements PropertyChangeListener,
    IWeakEventListener {
        private P_NlsClassPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("translationFilePrefix".equals(evt.getPropertyName()) || "translationFolderName".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.refresh();
            } else if ("superType".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.resetCache();
                SimpleNlsProject.this.setSuperType(SimpleNlsProject.this.getNlsType().getSuperType());
                SimpleNlsProject.this.fireNlsProjectEvent(new NlsProjectEvent(SimpleNlsProject.this, 16));
            }
        }
    }
}

