/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model.CountrySmartFieldModel;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model.LanguageSmartFieldModel;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model.TranslationFileNewModel;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.model.TranslationLocationSmartFieldModel;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.SmartField;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TranslationFileNewDialog
extends TitleAreaDialog {
    private SmartField m_languageChooser;
    private SmartField m_folderSelection;
    private SmartField m_languageCountryChooser;
    private final TranslationFileNewModel m_model;
    private final String m_title;

    public TranslationFileNewDialog(Shell parentShell, TranslationFileNewModel model) {
        super(parentShell);
        this.m_title = "Add a Language";
        this.m_model = model;
        this.m_model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TranslationFileNewDialog.this.revalidate();
            }
        });
        this.setHelpAvailable(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.m_title);
        this.revalidate();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_language_page_context");
        return contents;
    }

    protected Control createDialogArea(Composite p) {
        Composite rootArea = new Composite(p, 0);
        this.m_languageChooser = new SmartField(rootArea, 0, 20);
        this.m_languageChooser.setLabel("Language");
        this.m_languageChooser.setSmartFieldModel(new LanguageSmartFieldModel());
        this.m_languageChooser.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                String languageIso = null;
                if (item != null) {
                    languageIso = ((Locale)item).getLanguage();
                }
                TranslationFileNewDialog.this.m_model.setLanguageIso(languageIso);
            }
        });
        this.m_languageCountryChooser = new SmartField(rootArea, 0, 20);
        this.m_languageCountryChooser.setLabel("Country");
        this.m_languageCountryChooser.setSmartFieldModel(new CountrySmartFieldModel());
        this.m_languageCountryChooser.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                String countryIso = null;
                if (item != null) {
                    countryIso = ((Locale)item).getCountry();
                }
                TranslationFileNewDialog.this.m_model.setCountryIso(countryIso);
            }
        });
        this.m_folderSelection = new SmartField(rootArea, 0, 20);
        this.m_folderSelection.setLabel("Folder");
        TranslationLocationSmartFieldModel m = new TranslationLocationSmartFieldModel(this.m_model.getProject(), this.m_model.getPath());
        this.m_folderSelection.setSmartFieldModel(m);
        this.m_folderSelection.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                TranslationFileNewDialog.this.m_model.setFolder((IFolder)item);
            }
        });
        List<Object> folders = m.getProposals(null);
        if (folders.size() == 1) {
            this.m_folderSelection.setValue(folders.get(0));
        }
        TranslationFileNewDialog.attachGridData((Control)this.m_folderSelection);
        TranslationFileNewDialog.attachGridData((Control)this.m_languageCountryChooser);
        TranslationFileNewDialog.attachGridData((Control)this.m_languageChooser);
        rootArea.setLayoutData((Object)new GridData(1808));
        rootArea.setLayout((Layout)new GridLayout(1, true));
        return rootArea;
    }

    private void revalidate() {
        String langIso;
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        if ((langIso = this.m_model.getLanguageIso()) == null) {
            this.setMessage("Specify a language to add to the project.", 2);
            return;
        }
        String countryIso = this.m_model.getCountryIso();
        if (countryIso == null) {
            countryIso = "";
        }
        Language lang = new Language(new Locale(langIso, countryIso));
        if (this.m_model.getNlsProject().containsLanguage(lang)) {
            this.setMessage("This Language already exists.", 2);
            return;
        }
        if (this.m_model.getFolder() == null) {
            this.setMessage("Specify a folder where to create the translation file.", 2);
            return;
        }
        if (!this.m_model.getFolder().exists()) {
            this.setMessage("The folder could not be found.", 2);
            return;
        }
        this.setMessage("Adds a new Language to the project.");
        if (okButton != null) {
            okButton.setEnabled(true);
        }
    }

    private static void attachGridData(Control c) {
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        c.setLayoutData((Object)d);
    }
}

