/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldModel;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.SmartField;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.TextField;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractNlsEntryDialog
extends TitleAreaDialog {
    protected static final String DIALOG_SETTINGS_WIDTH = "dialogSettingsWidth";
    protected static final String DIALOG_SETTINGS_HEIGHT = "dialogSettingsHeight";
    protected static final String DIALOG_SETTINGS_X = "dialogSettingsX";
    protected static final String DIALOG_SETTINGS_Y = "dialogSettingsY";
    private NlsEntry m_nlsEntry;
    private INlsProject m_nlsProject;
    private boolean m_showProjectList;
    private boolean m_keyToClipboard;
    private final String m_title;
    private final Map<Language, TextField<String>> m_translationFields;
    private final INlsProject m_rootProject;
    private TextField<String> m_keyField;
    private SmartField m_projectProposalField;
    private Composite m_fixDialogArea;
    private Button m_copyKeyToClipboard;
    private Display m_display;

    protected AbstractNlsEntryDialog(Shell parentShell, String title, NlsEntry row, INlsProject project, boolean showProjectList) {
        super(parentShell);
        this.m_display = parentShell.getDisplay();
        this.m_nlsProject = project;
        this.m_title = title;
        this.m_nlsEntry = row;
        this.m_rootProject = project;
        this.m_translationFields = new HashMap<Language, TextField<String>>();
        this.m_showProjectList = showProjectList;
        this.setHelpAvailable(true);
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return NlsCore.getDefault().getDialogSettingsSection(String.valueOf(AbstractNlsEntryDialog.class.getName()) + ".dialogBounds");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.m_title);
        this.postCreate();
        this.getButton(0).setText("&Ok");
        this.getDefaultTranslationField().setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_nls-entry_page_context");
        return contents;
    }

    protected final Control createDialogArea(final Composite parent) {
        if (this.m_fixDialogArea == null) {
            this.m_fixDialogArea = new Composite(parent, 0);
            this.m_fixDialogArea.setLayoutData((Object)new GridData(1808));
            this.m_fixDialogArea.setLayout((Layout)new GridLayout(1, true));
        }
        final Composite rootArea = new Composite(this.m_fixDialogArea, 0);
        Composite inputComp = new Composite(rootArea, 0);
        P_ProjectSmartfieldModel model = new P_ProjectSmartfieldModel();
        if (model.getProposals("").size() < 2) {
            this.m_showProjectList = false;
        }
        this.m_projectProposalField = new SmartField(inputComp, 0, 10);
        this.m_projectProposalField.setLabel("Create in");
        this.m_projectProposalField.setSmartFieldModel(new P_ProjectSmartfieldModel());
        this.m_projectProposalField.setValue(this.getNlsProject());
        this.m_projectProposalField.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                if (item instanceof INlsProject && AbstractNlsEntryDialog.this.m_nlsProject != item) {
                    AbstractNlsEntryDialog.this.m_nlsProject = (INlsProject)item;
                    AbstractNlsEntryDialog.this.m_nlsEntry = new NlsEntry(AbstractNlsEntryDialog.this.m_nlsEntry, AbstractNlsEntryDialog.this.m_nlsProject);
                    rootArea.dispose();
                    AbstractNlsEntryDialog.this.createDialogArea(parent);
                    AbstractNlsEntryDialog.this.postCreate();
                    AbstractNlsEntryDialog.this.m_fixDialogArea.layout(true, true);
                    parent.redraw();
                    AbstractNlsEntryDialog.this.m_keyField.validate();
                }
            }
        });
        this.m_projectProposalField.setVisible(this.isShowProjectList());
        this.m_keyField = new TextField(inputComp, 8, "Key Name", 10);
        String key = this.m_nlsEntry.getKey();
        if (key == null) {
            key = "";
        }
        this.m_keyField.setValue(key);
        this.m_keyField.addInputChangedListener(new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                AbstractNlsEntryDialog.this.m_nlsEntry.setKey(input);
            }
        });
        final TabFolder translationGroup = new TabFolder(rootArea, 0);
        translationGroup.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                translationGroup.getItem(translationGroup.getSelectionIndex()).getControl().setFocus();
            }
        });
        this.m_translationFields.clear();
        for (Language l : this.m_nlsProject.getAllLanguages()) {
            TranslationField field = new TranslationField(l);
            TextField<String> control = field.create((Composite)translationGroup);
            control.setValue("");
            TabItem tabItem = new TabItem(translationGroup, 0);
            tabItem.setText(l.getDispalyName());
            tabItem.setControl(control);
            GridData txtGd = new GridData(1808);
            txtGd.minimumHeight = 80;
            control.setLayoutData(txtGd);
            field.setText(this.m_nlsEntry.getTranslation(l));
            this.m_translationFields.put(l, control);
        }
        this.m_copyKeyToClipboard = new Button(rootArea, 32);
        this.m_copyKeyToClipboard.setText("Copy key to clipboard");
        this.m_copyKeyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNlsEntryDialog.this.m_keyToClipboard = AbstractNlsEntryDialog.this.m_copyKeyToClipboard.getSelection();
            }
        });
        rootArea.setLayoutData((Object)new GridData(1808));
        rootArea.setLayout((Layout)new GridLayout(1, true));
        GridData plgd = new GridData(768);
        plgd.exclude = !this.isShowProjectList();
        this.m_projectProposalField.setLayoutData(plgd);
        GridData data = new GridData(300, -1);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        inputComp.setLayoutData((Object)data);
        inputComp.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(768);
        this.m_keyField.setLayoutData(data);
        data = new GridData(1808);
        data.widthHint = 600;
        data.heightHint = 100;
        translationGroup.setLayoutData((Object)data);
        translationGroup.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(768);
        this.m_copyKeyToClipboard.setLayoutData((Object)data);
        return this.m_fixDialogArea;
    }

    public final TextField<String> getKeyField() {
        return this.m_keyField;
    }

    public final SmartField getProjectProposalField() {
        return this.m_projectProposalField;
    }

    public NlsEntry show() {
        if (this.open() == 0) {
            if (this.m_keyToClipboard) {
                this.copyKeyToClipboard();
            }
            return this.m_nlsEntry;
        }
        return null;
    }

    private void copyKeyToClipboard() {
        String key;
        if (this.m_nlsEntry != null && (key = this.getNlsEntry().getKey()) != null && key.length() > 0) {
            Clipboard clipboard = new Clipboard(this.m_display);
            String rtfData = "{\\rtf1\\b\\i " + key + "}";
            TextTransfer textTransfer = TextTransfer.getInstance();
            RTFTransfer rtfTransfer = RTFTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer, rtfTransfer};
            Object[] data = new Object[]{key, rtfData};
            clipboard.setContents(data, transfers);
            clipboard.dispose();
        }
    }

    protected void postCreate() {
    }

    protected abstract void revalidate();

    protected TextField<String> getTranslationField(Language language) {
        return this.m_translationFields.get(language);
    }

    protected TextField<String> getDefaultTranslationField() {
        return this.getTranslationField(Language.LANGUAGE_DEFAULT);
    }

    public void setMessage(IStatus status) {
        int sev = 0;
        switch (status.getSeverity()) {
            case 4: {
                sev = 3;
                break;
            }
            case 2: {
                sev = 2;
                break;
            }
            case 1: {
                sev = 1;
            }
        }
        this.setMessage(status.getMessage(), sev);
    }

    public NlsEntry getNlsEntry() {
        return this.m_nlsEntry;
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }

    private boolean isShowProjectList() {
        return this.m_showProjectList;
    }

    private class P_ProjectSmartfieldModel
    implements ISmartFieldModel {
        private P_ProjectSmartfieldModel() {
        }

        @Override
        public List<Object> getProposals(String pattern) {
            ArrayList<Object> collector = new ArrayList<Object>();
            INlsProject p = AbstractNlsEntryDialog.this.m_rootProject;
            do {
                List<Language> languages;
                if ((languages = p.getAllLanguages()).size() <= 0 || p.getTranslationResource(languages.get(0)).isReadOnly() || pattern != null && pattern.length() >= 1 && !p.getName().toLowerCase().startsWith(pattern.toLowerCase())) continue;
                collector.add(p);
            } while ((p = p.getParent()) != null);
            return collector;
        }

        @Override
        public String getText(Object item) {
            if (item instanceof INlsProject) {
                return ((INlsProject)item).getName();
            }
            return null;
        }

        @Override
        public Image getImage(Object item) {
            return null;
        }
    }

    protected class TranslationField {
        private TextField<String> m_input;
        private Language m_language;

        protected TranslationField(Language language) {
            this.m_language = language;
        }

        protected TextField<String> create(Composite parent) {
            this.m_input = new TextField(parent, 10, "");
            this.m_input.setLabelVisible(false);
            this.m_input.addInputChangedListener(new IInputChangedListener<String>(){

                @Override
                public void inputChanged(String input) {
                    if (input == null || input.length() < 1) {
                        AbstractNlsEntryDialog.this.m_nlsEntry.removeTranslation(TranslationField.this.m_language);
                    } else {
                        AbstractNlsEntryDialog.this.m_nlsEntry.addTranslation(TranslationField.this.m_language, input);
                    }
                }
            });
            this.m_input.addInputChangedListener(new IInputChangedListener<String>(){
                private String m_oldInput;

                @Override
                public void inputChanged(String input) {
                    if (AbstractNlsEntryDialog.this.m_keyField.isEnabled() && input != null && input.length() > 0) {
                        String oldKey = AbstractNlsEntryDialog.this.getNlsProject().generateNewKey(this.m_oldInput);
                        String curVal = (String)AbstractNlsEntryDialog.this.m_keyField.getValue();
                        if (curVal != null && curVal.length() < 1) {
                            curVal = null;
                        }
                        if (curVal == null || Objects.equals(curVal, oldKey)) {
                            AbstractNlsEntryDialog.this.m_keyField.setValue(AbstractNlsEntryDialog.this.getNlsProject().generateNewKey(input));
                        }
                    }
                    this.m_oldInput = input;
                }
            });
            return this.m_input;
        }

        public void setText(String text) {
            if (text == null) {
                text = "";
            }
            this.m_input.setValue(text);
        }
    }
}

