/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.proposal;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.proposal.AbstractNlsProposal;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NlsProposal
extends AbstractNlsProposal {
    private final INlsEntry m_nlsEntry;
    private final Image m_image;

    public NlsProposal(INlsEntry nlsEntry, String prefix, int initialOffset, Image image) {
        super(prefix, initialOffset);
        this.m_nlsEntry = nlsEntry;
        this.m_image = image;
    }

    @Override
    public int getRelevance() {
        return 1;
    }

    @Override
    public String getAdditionalProposalInfo() {
        Map<Language, String> allTranslations = this.m_nlsEntry.getAllTranslations();
        if (allTranslations == null || allTranslations.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Language, String> e : allTranslations.entrySet()) {
            String text = e.getValue();
            if (text == null) continue;
            text = StringUtils.replaceEach((String)CoreUtils.escapeHtml((String)text), (String[])new String[]{"\n", "\r"}, (String[])new String[]{"<br>", ""});
            b.append("<b>").append(text).append("</b> [").append(e.getKey().getDispalyName()).append("]<br>");
        }
        return b.toString();
    }

    public String getDisplayString() {
        return this.m_nlsEntry.getKey();
    }

    public Image getImage() {
        return this.m_image;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            this.replaceWith(document, offset, this.m_nlsEntry.getKey());
        }
        catch (BadLocationException e) {
            SdkLog.error((Object[])new Object[]{e});
        }
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (super.validate(document, offset, event)) {
            try {
                Point keyRange = this.findKeyRange(document, offset);
                String prefix = document.get(keyRange.x, offset - keyRange.x);
                return this.m_nlsEntry.getKey().toLowerCase().startsWith(prefix.toLowerCase());
            }
            catch (BadLocationException e) {
                SdkLog.warning((Object[])new Object[]{e});
                return false;
            }
        }
        return false;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.m_nlsEntry.getKey();
    }

    @Override
    public boolean isAutoInsertable() {
        return true;
    }
}

