/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.file;

import java.io.File;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.scout.sdk.core.util.OptimisticLock;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.file.IFileSelectionListener;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextEx;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FileSelectionField
extends TextField {
    private Button m_popupButton;
    private File m_file;
    private boolean m_folderMode;
    private String[] m_filterExtensions;
    private String m_fileName;
    private final EventListenerList m_eventListeners;
    private final OptimisticLock m_inputLock = new OptimisticLock();

    public FileSelectionField(Composite parent) {
        this(parent, 20);
    }

    public FileSelectionField(Composite parent, int labelPercentage) {
        super(parent, labelPercentage);
        this.m_eventListeners = new EventListenerList();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_popupButton.setEnabled(enabled);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledTextEx text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 0x800008);
        this.m_popupButton.setText("Browse...");
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionField.this.showFileChooserDialog();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (FileSelectionField.this.m_inputLock.acquire()) {
                        String input = FileSelectionField.this.getText();
                        if (StringUtils.isBlank((CharSequence)input)) {
                            FileSelectionField.this.setFileInternal(null);
                        } else {
                            File newFile = new File(input);
                            try {
                                newFile.getCanonicalPath();
                                FileSelectionField.this.setFileInternal(newFile);
                            }
                            catch (Exception ex) {
                                FileSelectionField.this.setFileInternal(null);
                            }
                        }
                    }
                }
                finally {
                    FileSelectionField.this.m_inputLock.release();
                }
            }
        });
        parent.setTabList(new Control[]{text});
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.getLabelPercentage(), 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData(textData);
        FormData buttonData = new FormData();
        buttonData.width = 70;
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    private void showFileChooserDialog() {
        DirectoryDialog dialog;
        String fileName = null;
        if (this.isFolderMode()) {
            dialog = new DirectoryDialog(this.getShell());
            if (this.getFile() != null) {
                dialog.setFilterPath(this.getFile().getAbsolutePath());
            }
            fileName = dialog.open();
        } else {
            dialog = new FileDialog(this.getShell());
            if (this.getFileName() != null) {
                dialog.setFileName(this.getFileName());
            }
            dialog.setOverwrite(true);
            if (this.getFilterExtensions() != null) {
                dialog.setFilterExtensions(this.getFilterExtensions());
            }
            if (StringUtils.isNotEmpty((CharSequence)(fileName = dialog.open())) && this.getFilterExtensions() != null && this.getFilterExtensions().length > 0) {
                int extIndex = dialog.getFilterIndex();
                Matcher m = Pattern.compile("\\.([^\\.]*)$").matcher(fileName);
                String extension = null;
                if (m.find()) {
                    String[] stringArray = this.getFilterExtensions();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fExt = stringArray[n2];
                        if (StringUtils.equalsIgnoreCase((CharSequence)fExt, (CharSequence)("*." + m.group(1)))) {
                            extension = m.group(1);
                            break;
                        }
                        ++n2;
                    }
                }
                if (extension == null && extIndex > -1 && extIndex < this.getFilterExtensions().length) {
                    extension = this.getFilterExtensions()[extIndex];
                    extension = extension.replaceFirst("\\**", "");
                    fileName = String.valueOf(fileName) + extension;
                }
            }
        }
        File newFile = null;
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            newFile = new File(fileName);
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(newFile.getAbsolutePath());
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
        this.setFileInternal(newFile);
    }

    public void addFileSelectionListener(IFileSelectionListener listener) {
        this.m_eventListeners.add(IFileSelectionListener.class, listener);
    }

    public void removeFileSelectionListener(IFileSelectionListener listener) {
        this.m_eventListeners.remove(IFileSelectionListener.class, listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.getTextComponent().addTraverseListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.getTextComponent().removeTraverseListener(listener);
    }

    private void fireFileSelected(File file) {
        IFileSelectionListener[] iFileSelectionListenerArray = (IFileSelectionListener[])this.m_eventListeners.getListeners(IFileSelectionListener.class);
        int n = iFileSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileSelectionListener l = iFileSelectionListenerArray[n2];
            try {
                l.fileSelected(file);
            }
            catch (Exception t) {
                SdkLog.error((String)"error during listener notification.", (Object[])new Object[]{t});
            }
            ++n2;
        }
    }

    public boolean isFolderMode() {
        return this.m_folderMode;
    }

    public void setFolderMode(boolean folderMode) {
        this.m_folderMode = folderMode;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.m_filterExtensions = filterExtensions;
    }

    public String[] getFilterExtensions() {
        return this.m_filterExtensions;
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File file) {
        this.m_file = file;
        if (!this.isDisposed()) {
            String text = "";
            if (file != null) {
                text = file.getAbsolutePath();
            }
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(text);
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }

    private void setFileInternal(File file) {
        if (!Objects.equals(this.getFile(), file)) {
            this.setFile(file);
            this.fireFileSelected(file);
        }
    }
}

