/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkConsole;
import org.eclipse.scout.sdk.s2e.internal.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class WorkbenchSdkConsoleSpi
implements SdkConsole.SdkConsoleSpi {
    private static final String CONSOLE_NAME = "Scout SDK";
    private static final String CONSOLE_TYPE = "org.eclipse.scout.sdk";

    public void clear() {
        IOConsole console = WorkbenchSdkConsoleSpi.currentConsole(false);
        if (console != null) {
            console.clearConsole();
        }
    }

    public void println(String s, Throwable ... exceptions) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IOConsoleOutputStream out = WorkbenchSdkConsoleSpi.currentConsole(true).newOutputStream();){
                out.write(s);
                if (exceptions == null) {
                    out.write(10);
                } else {
                    Throwable[] throwableArray = exceptions;
                    int n = exceptions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Throwable t = throwableArray[n2];
                        if (t != null) {
                            String trace = CoreUtils.getStackTrace((Throwable)t);
                            out.write(trace);
                        }
                        ++n2;
                    }
                }
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to write to console:");
            System.out.println(s);
        }
        if (Platform.isRunning() && (Platform.inDebugMode() || Platform.inDevelopmentMode())) {
            S2ESdkActivator activator = S2ESdkActivator.getDefault();
            if (activator == null) {
                return;
            }
            Throwable t = null;
            if (exceptions != null && exceptions.length > 0) {
                t = exceptions[0];
            }
            activator.getLog().log((IStatus)new Status(WorkbenchSdkConsoleSpi.parseSeverity(s), "org.eclipse.scout.sdk.s2e", s, t));
        }
    }

    private static int parseSeverity(String s) {
        int num;
        block7: {
            if (StringUtils.length((CharSequence)s) < 1) {
                return 0;
            }
            if (s.charAt(0) != '[') {
                return 0;
            }
            int endPos = s.indexOf(93);
            if (endPos <= 0) {
                return 0;
            }
            String level = s.substring(1, endPos);
            try {
                Level l = Level.parse(level);
                num = l.intValue();
                if (num != Level.SEVERE.intValue()) break block7;
                return 4;
            }
            catch (IllegalArgumentException e) {
                return 0;
            }
        }
        if (num == Level.WARNING.intValue()) {
            return 2;
        }
        return 1;
    }

    public static IOConsole currentConsole(boolean autoCreate) {
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        IOConsole console = null;
        IConsole[] iConsoleArray = mgr.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (CONSOLE_NAME.equals(c.getName()) && CONSOLE_TYPE.equals(c.getType())) {
                if (console == null) {
                    console = (IOConsole)c;
                } else {
                    mgr.removeConsoles(new IConsole[]{c});
                }
            }
            ++n2;
        }
        if (console == null && autoCreate) {
            console = new IOConsole(CONSOLE_NAME, CONSOLE_TYPE, S2ESdkUiActivator.getImageDescriptor("eclipse_scout.gif")){

                public void clearConsole() {
                    super.clearConsole();
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
                }
            };
            mgr.addConsoles(new IConsole[]{console});
            mgr.showConsoleView((IConsole)console);
        }
        return console;
    }
}

