/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.classid;

import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.classid.ClassIdValidationJob;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.AnnotationNewOperation;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.IMarkerResolution;

public class ClassIdDuplicateResolution
implements IMarkerResolution {
    private final IAnnotation m_annotation;

    public ClassIdDuplicateResolution(IAnnotation annotation) {
        this.m_annotation = annotation;
    }

    public String getLabel() {
        return "Update with new @ClassId value";
    }

    public void run(final IMarker marker) {
        IType parent = (IType)this.m_annotation.getAncestor(7);
        if (S2eUtils.exists((IJavaElement)parent)) {
            LinkedList<IOperation> ops = new LinkedList<IOperation>();
            String newId = ClassIdGenerators.generateNewId((ClassIdGenerationContext)new ClassIdGenerationContext(parent));
            if (StringUtils.isNotBlank((CharSequence)newId)) {
                ops.add(ClassIdDuplicateResolution.createUpdateAnnotationInJavaSourceOperation(parent, newId));
            }
            if (!ops.isEmpty()) {
                ResourceBlockingOperationJob j = new ResourceBlockingOperationJob(ops);
                j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        try {
                            marker.delete();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        ClassIdValidationJob.executeAsync((long)0L);
                    }
                });
                j.schedule();
            }
        }
    }

    private static IOperation createUpdateAnnotationInJavaSourceOperation(IType annotationOwner, String newId) {
        return new AnnotationNewOperation(ScoutAnnotationSourceBuilderFactory.createClassId((String)newId), (IMember)annotationOwner);
    }
}

