/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.classid;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;
import org.eclipse.text.edits.TextEdit;

public class ClassIdQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        IJavaCompletionProposal[] assists = this.getAssists(context, null);
        return assists != null && assists.length > 0;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        CompilationUnitRewrite rewrite;
        ClassIdTarget selectedType = ClassIdQuickAssistProcessor.getTarget(context.getCoveringNode());
        if (selectedType != null && !S2eUtils.exists((IJavaElement)selectedType.annotation) && (rewrite = ClassIdQuickAssistProcessor.createRewrite(selectedType.type, selectedType.td)) != null) {
            return new IJavaCompletionProposal[]{new ClassIdAddProposal(rewrite)};
        }
        return null;
    }

    private static CompilationUnitRewrite createRewrite(IType type, TypeDeclaration td) {
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, type.getCompilationUnit(), (CompilationUnit)td.getRoot());
        ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)td, td.getModifiersProperty());
        AstNodeFactory factory = new AstNodeFactory(td, type.getCompilationUnit());
        SingleMemberAnnotation classIdAnnotation = factory.newClassIdAnnotation(new ClassIdGenerationContext(type));
        cuRewrite.getImportRewrite().addImport("org.eclipse.scout.rt.platform.classid.ClassId");
        ASTNode sibling = AstUtils.getAnnotationSibling((BodyDeclaration)td, (Annotation)classIdAnnotation);
        if (sibling == null) {
            listRewrite.insertLast((ASTNode)classIdAnnotation, null);
        } else {
            listRewrite.insertBefore((ASTNode)classIdAnnotation, sibling, null);
        }
        return cuRewrite;
    }

    private static ClassIdTarget getTarget(ASTNode selectedNode) {
        if (selectedNode != null && selectedNode.getParent() != null && (selectedNode.getNodeType() == 42 || selectedNode.getNodeType() == 40 || selectedNode.getNodeType() == 83 || selectedNode.getNodeType() == 55)) {
            IJavaElement javaElement;
            TypeDeclaration typeDecl = null;
            if (selectedNode.getParent().getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode.getParent();
            } else if (selectedNode.getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode;
            } else {
                return null;
            }
            ITypeBinding resolveTypeBinding = typeDecl.resolveBinding();
            if (resolveTypeBinding != null && S2eUtils.exists((IJavaElement)(javaElement = resolveTypeBinding.getJavaElement())) && javaElement.getElementType() == 7) {
                IType t = (IType)javaElement;
                try {
                    ITypeHierarchy superTypeHierarchy;
                    if (!t.isBinary() && !t.isAnonymous() && S2eUtils.hierarchyContains((ITypeHierarchy)(superTypeHierarchy = t.newSupertypeHierarchy(null)), (String)"org.eclipse.scout.rt.platform.classid.ITypeWithClassId")) {
                        IAnnotation annotation = S2eUtils.getAnnotation((IAnnotatable)t, (String)"org.eclipse.scout.rt.platform.classid.ClassId");
                        return new ClassIdTarget(typeDecl, t, annotation);
                    }
                }
                catch (CoreException e) {
                    SdkLog.error((String)"Unable to check if type '{}' is anonymous.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
                }
            }
        }
        return null;
    }

    private static final class ClassIdAddProposal
    extends CUCorrectionProposal {
        private final CompilationUnitRewrite m_rewrite;

        private ClassIdAddProposal(CompilationUnitRewrite cur) {
            super("Add @ClassId annotation", cur.getCu(), 1000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
            this.m_rewrite = cur;
        }

        protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
            Map options = this.m_rewrite.getCu().getJavaProject().getOptions(true);
            editRoot.addChild(this.m_rewrite.getASTRewrite().rewriteAST(document, options));
            if (this.m_rewrite.getImportRewrite().hasRecordedChanges()) {
                editRoot.addChild(this.m_rewrite.getImportRewrite().rewriteImports(null));
            }
        }
    }

    private static final class ClassIdTarget {
        private final TypeDeclaration td;
        private final IType type;
        private final IAnnotation annotation;

        private ClassIdTarget(TypeDeclaration td, IType type, IAnnotation annotation) {
            this.td = td;
            this.type = type;
            this.annotation = annotation;
        }
    }
}

