/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.form;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.form.FormNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.form.FormNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class FormNewWizard
extends AbstractWizard
implements INewWizard {
    public static Class<? extends FormNewWizardPage> pageClass = FormNewWizardPage.class;
    private FormNewWizardPage m_page1;
    private boolean m_executed = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PackageContainer packageContainer = S2eUiUtils.getClientPackageOfSelection((ISelection)selection);
        try {
            this.m_page1 = pageClass.getConstructor(PackageContainer.class).newInstance(packageContainer);
            this.addPage((IWizardPage)this.m_page1);
            this.setWindowTitle(this.m_page1.getTitle());
            this.setHelpAvailable(true);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        }
        catch (InvocationTargetException e) {
            throw new SdkException(e.getCause());
        }
        catch (Exception e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void scheduleFormCreation(FormNewOperation op) {
        this.scheduleFormCreation(op, null);
    }

    public void scheduleFormCreation(final FormNewOperation op, Set<IResource> blockingFolders) {
        if (this.isExecuted()) {
            return;
        }
        if (blockingFolders == null) {
            blockingFolders = new HashSet<IResource>(4);
        }
        op.setClientPackage(this.m_page1.getTargetPackage());
        op.setClientSourceFolder(this.m_page1.getSourceFolder());
        blockingFolders.add(this.m_page1.getSourceFolder().getResource());
        op.setCreateFormData(this.m_page1.isCreateFormData());
        op.setCreatePermissions(this.m_page1.isCreatePermissions());
        op.setCreateService(this.m_page1.isCreateService());
        op.setFormName(this.m_page1.getIcuName());
        if (this.m_page1.isCreateService()) {
            op.setServerSourceFolder(this.m_page1.getServerSourceFolder());
            blockingFolders.add(this.m_page1.getServerSourceFolder().getResource());
        }
        if (this.m_page1.isCreateFormData()) {
            IPackageFragmentRoot sharedSourceFolder = S2eUtils.getDtoSourceFolder((IPackageFragmentRoot)this.m_page1.getSharedSourceFolder());
            op.setFormDataSourceFolder(sharedSourceFolder);
            blockingFolders.add(sharedSourceFolder.getResource());
        }
        if (this.m_page1.isCreatePermissions() || this.m_page1.isCreateService()) {
            op.setSharedSourceFolder(this.m_page1.getSharedSourceFolder());
            blockingFolders.add(this.m_page1.getSharedSourceFolder().getResource());
        }
        op.setSuperType(this.m_page1.getSuperType());
        final Display d = this.getContainer().getShell().getDisplay();
        ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op, blockingFolders.toArray(new IResource[blockingFolders.size()]));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IType createdForm = op.getCreatedForm();
                        if (!S2eUtils.exists((IJavaElement)createdForm)) {
                            return;
                        }
                        try {
                            JavaUI.openInEditor((IJavaElement)createdForm, (boolean)true, (boolean)true);
                        }
                        catch (JavaModelException | PartInitException e) {
                            SdkLog.info((String)"Unable to open type {} in editor.", (Object[])new Object[]{createdForm.getFullyQualifiedName(), e});
                        }
                    }
                });
            }
        });
        job.schedule();
        this.setExecuted(true);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (!this.isExecuted()) {
            this.scheduleFormCreation(new FormNewOperation());
        }
        return true;
    }

    public boolean isExecuted() {
        return this.m_executed;
    }

    protected void setExecuted(boolean executed) {
        this.m_executed = executed;
    }
}

