/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.page.PageNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.page.PageNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class PageNewWizard
extends AbstractWizard
implements INewWizard {
    public static Class<? extends PageNewWizardPage> pageClass = PageNewWizardPage.class;
    private PageNewWizardPage m_page1;
    private boolean m_executed = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PackageContainer packageContainer = S2eUiUtils.getClientPackageOfSelection((ISelection)selection);
        try {
            this.m_page1 = pageClass.getConstructor(PackageContainer.class).newInstance(packageContainer);
            this.addPage((IWizardPage)this.m_page1);
            this.setWindowTitle(this.m_page1.getTitle());
            this.setHelpAvailable(true);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        }
        catch (InvocationTargetException e) {
            throw new SdkException(e.getCause());
        }
        catch (Exception e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void schedulePageCreation(final PageNewOperation op) {
        IPackageFragmentRoot selectedServerFolder;
        if (this.isExecuted()) {
            return;
        }
        HashSet<IResource> blockedFolders = new HashSet<IResource>(4);
        op.setClientSourceFolder(this.m_page1.getSourceFolder());
        blockedFolders.add(this.m_page1.getSourceFolder().getResource());
        op.setPackage(this.m_page1.getTargetPackage());
        op.setPageName(this.m_page1.getIcuName());
        IPackageFragmentRoot selectedSharedFolder = this.m_page1.getSharedSourceFolder();
        if (S2eUtils.exists((IJavaElement)selectedSharedFolder)) {
            op.setSharedSourceFolder(selectedSharedFolder);
            blockedFolders.add(selectedSharedFolder.getResource());
            IPackageFragmentRoot dtoSourceFolder = S2eUtils.getDtoSourceFolder((IPackageFragmentRoot)selectedSharedFolder);
            op.setPageDataSourceFolder(dtoSourceFolder);
            blockedFolders.add(dtoSourceFolder.getResource());
        }
        if (S2eUtils.exists((IJavaElement)(selectedServerFolder = this.m_page1.getServerSourceFolder()))) {
            op.setServerSourceFolder(selectedServerFolder);
            blockedFolders.add(selectedServerFolder.getResource());
        }
        op.setSuperType(this.m_page1.getSuperType());
        final Display d = this.getContainer().getShell().getDisplay();
        ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op, blockedFolders.toArray(new IResource[blockedFolders.size()]));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IType createdPageType = op.getCreatedPage();
                        if (!S2eUtils.exists((IJavaElement)createdPageType)) {
                            return;
                        }
                        try {
                            JavaUI.openInEditor((IJavaElement)createdPageType, (boolean)true, (boolean)true);
                        }
                        catch (JavaModelException | PartInitException e) {
                            SdkLog.info((String)"Unable to open type {} in editor.", (Object[])new Object[]{createdPageType.getFullyQualifiedName(), e});
                        }
                    }
                });
            }
        });
        job.schedule();
        this.setExecuted(true);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (!this.isExecuted()) {
            this.schedulePageCreation(new PageNewOperation());
        }
        return true;
    }

    public boolean isExecuted() {
        return this.m_executed;
    }

    protected void setExecuted(boolean executed) {
        this.m_executed = executed;
    }
}

