/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.permission;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.permission.PermissionNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.permission.PermissionNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class PermissionNewWizard
extends AbstractWizard
implements INewWizard {
    public static Class<? extends PermissionNewWizardPage> pageClass = PermissionNewWizardPage.class;
    private PermissionNewWizardPage m_page1;
    private boolean m_executed = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PackageContainer packageContainer = S2eUiUtils.getSharedPackageOfSelection((ISelection)selection);
        try {
            this.m_page1 = pageClass.getConstructor(PackageContainer.class).newInstance(packageContainer);
            this.addPage((IWizardPage)this.m_page1);
            this.setWindowTitle(this.m_page1.getTitle());
            this.setHelpAvailable(true);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        }
        catch (InvocationTargetException e) {
            throw new SdkException(e.getCause());
        }
        catch (Exception e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void schedulePermissionCreation(final PermissionNewOperation op) {
        if (this.isExecuted()) {
            return;
        }
        op.setPackage(this.m_page1.getTargetPackage());
        op.setPermissionName(this.m_page1.getIcuName());
        op.setSharedSourceFolder(this.m_page1.getSourceFolder());
        op.setSuperType(this.m_page1.getSuperType());
        final Display d = this.getContainer().getShell().getDisplay();
        ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op, new IResource[]{this.m_page1.getSourceFolder().getResource()});
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IType createdPermissionType = op.getCreatedPermission();
                        if (!S2eUtils.exists((IJavaElement)createdPermissionType)) {
                            return;
                        }
                        try {
                            JavaUI.openInEditor((IJavaElement)createdPermissionType, (boolean)true, (boolean)true);
                        }
                        catch (JavaModelException | PartInitException e) {
                            SdkLog.info((String)"Unable to open type {} in editor.", (Object[])new Object[]{createdPermissionType.getFullyQualifiedName(), e});
                        }
                    }
                });
            }
        });
        job.schedule();
        this.setExecuted(true);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (!this.isExecuted()) {
            this.schedulePermissionCreation(new PermissionNewOperation());
        }
        return true;
    }

    public boolean isExecuted() {
        return this.m_executed;
    }

    protected void setExecuted(boolean executed) {
        this.m_executed = executed;
    }
}

