/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.ui.IWorkingSet;

public final class S2eUiUtils {
    private S2eUiUtils() {
    }

    public static PackageContainer getClientPackageOfSelection(ISelection selection) {
        Comparator<IJavaElement> elementComparator = new Comparator<IJavaElement>(){

            @Override
            public int compare(IJavaElement o1, IJavaElement o2) {
                int result = Integer.compare(this.getRanking(o1), this.getRanking(o2));
                if (result != 0) {
                    return result;
                }
                result = o1.getElementName().compareTo(o2.getElementName());
                if (result != 0) {
                    return result;
                }
                return o1.toString().compareTo(o2.toString());
            }

            private int getRanking(IJavaElement element) {
                ScoutTier tier;
                block7: {
                    try {
                        tier = ScoutTier.valueOf((IJavaElement)element);
                        if (tier != null) break block7;
                        return 100;
                    }
                    catch (JavaModelException ex) {
                        throw new SdkException((Throwable)ex);
                    }
                }
                switch (tier) {
                    case Client: {
                        return 5;
                    }
                    case HtmlUi: {
                        return 10;
                    }
                }
                return 15;
            }
        };
        return S2eUiUtils.getPackageOfSelection(selection, elementComparator, ScoutTier.Client);
    }

    public static PackageContainer getSharedPackageOfSelection(ISelection selection) {
        Comparator<IJavaElement> elementComparator = new Comparator<IJavaElement>(){

            @Override
            public int compare(IJavaElement o1, IJavaElement o2) {
                int result = o1.getElementName().compareTo(o2.getElementName());
                if (result != 0) {
                    return result;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        return S2eUiUtils.getPackageOfSelection(selection, elementComparator, ScoutTier.Shared);
    }

    private static PackageContainer getPackageOfSelection(ISelection selection, Comparator<IJavaElement> javaElementComparator, ScoutTier expected) {
        Set<IResource> selectedResources = S2eUiUtils.getResourcesOfSelection(selection);
        PackageContainer result = new PackageContainer();
        if (selectedResources.isEmpty()) {
            return result;
        }
        try {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>(selectedResources.size());
            ArrayList<IJavaElement> unaccepted = new ArrayList<IJavaElement>(selectedResources.size());
            for (IResource r : selectedResources) {
                IJavaElement element = JavaCore.create((IResource)r);
                if (!S2eUtils.exists((IJavaElement)element)) continue;
                if (expected.equals((Object)ScoutTier.valueOf((IJavaElement)element))) {
                    elements.add(element);
                    continue;
                }
                unaccepted.add(element);
            }
            if (elements.isEmpty() && !unaccepted.isEmpty()) {
                ScoutTier foundTier;
                PackageContainer unacceptedResult = new PackageContainer();
                S2eUiUtils.fillContainer(unaccepted, unacceptedResult, javaElementComparator);
                if (S2eUtils.exists((IJavaElement)unacceptedResult.getProject()) && (foundTier = ScoutTier.valueOf((IJavaElement)unacceptedResult.getProject())) != null) {
                    result.setProject(foundTier.convert(expected, unacceptedResult.getProject()));
                    result.setSrcFolder(foundTier.convert(expected, unacceptedResult.getSrcFolder()));
                    result.setPackage(foundTier.convert(expected, unacceptedResult.getPackage()));
                }
            } else {
                S2eUiUtils.fillContainer(elements, result, javaElementComparator);
            }
        }
        catch (Exception e) {
            SdkLog.warning((String)"Unable to parse source folder of selection {}", (Object[])new Object[]{selection, e});
        }
        return result;
    }

    private static void fillContainer(List<IJavaElement> candidates, PackageContainer result, Comparator<IJavaElement> javaElementComparator) throws JavaModelException {
        IJavaProject javaProject;
        Collections.sort(candidates, javaElementComparator);
        IJavaElement element = candidates.get(0);
        result.setPackage((IPackageFragment)element.getAncestor(4));
        IPackageFragmentRoot pckFragRoot = (IPackageFragmentRoot)element.getAncestor(3);
        if (S2eUtils.exists((IJavaElement)pckFragRoot) && pckFragRoot.getKind() == 1) {
            result.setSrcFolder(pckFragRoot);
        }
        if (S2eUtils.exists((IJavaElement)(javaProject = (IJavaProject)element.getAncestor(2)))) {
            result.setProject(javaProject);
            if (result.getSrcFolder() == null) {
                result.setSrcFolder(S2eUtils.getPrimarySourceFolder((IJavaProject)javaProject));
            }
        }
    }

    public static Set<IResource> getResourcesOfSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            IJavaElement activeEditorJavaInput = EditorUtility.getActiveEditorJavaInput();
            if (!S2eUtils.exists((IJavaElement)activeEditorJavaInput)) {
                return Collections.emptySet();
            }
            selection = new StructuredSelection((Object)activeEditorJavaInput);
        }
        IStructuredSelection structSel = (IStructuredSelection)selection;
        LinkedHashSet<IResource> resourceSet = new LinkedHashSet<IResource>(structSel.size());
        for (Object selElem : structSel) {
            if (selElem instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)selElem;
                if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) continue;
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable workingSetElement = iAdaptableArray[n2];
                    S2eUiUtils.addAdaptableResource(workingSetElement, resourceSet);
                    ++n2;
                }
                continue;
            }
            if (!(selElem instanceof IAdaptable)) continue;
            S2eUiUtils.addAdaptableResource((IAdaptable)selElem, resourceSet);
        }
        return resourceSet;
    }

    private static void addAdaptableResource(IAdaptable a, Collection<IResource> collector) {
        IResource resource;
        Object o = a.getAdapter(IResource.class);
        if (o instanceof IResource && (resource = (IResource)o).isAccessible()) {
            collector.add(resource);
        }
    }
}

