/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class CachingJavaEnvironmentProvider
implements IJavaEnvironmentProvider {
    private final Map<IJavaProject, IJavaEnvironment> m_envs = new HashMap<IJavaProject, IJavaEnvironment>();

    @Override
    public org.eclipse.scout.sdk.core.model.api.IType jdtTypeToScoutType(IType jdtType) {
        if (jdtType == null) {
            return null;
        }
        return S2eUtils.jdtTypeToScoutType(jdtType, this.getOrCreateEnv(jdtType.getJavaProject()));
    }

    @Override
    public IJavaEnvironment get(IJavaProject jdtProject) {
        return this.getOrCreateEnv(jdtProject);
    }

    private IJavaEnvironment getOrCreateEnv(IJavaProject jdtProject) {
        if (jdtProject == null) {
            return null;
        }
        IJavaEnvironment env = this.m_envs.get(jdtProject);
        if (env == null) {
            env = ScoutSdkCore.createJavaEnvironment(jdtProject);
            this.m_envs.put(jdtProject, env);
        }
        return env;
    }
}

