/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.classid;

import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.IClassIdGenerator;

public final class ClassIdGenerators {
    private static final String EXTENSION_POINT_NAME = "classIdGenerator";
    private static final String TAG_NAME = "generator";
    private static final String ATTRIB_CLASS = "class";
    private static final String ATTRIB_PRIO = "priority";
    private static final Object LOCK = new Object();
    private static volatile Collection<IClassIdGenerator> allGeneratorsOrdered = null;
    private static boolean automaticallyCreateClassIdAnnotation = false;
    public static final String PROP_AUTOMATICALLY_CREATE_CLASS_ID_ANNOTATION = "org.eclipse.scout.sdk.propAutoCreateClassId";

    private ClassIdGenerators() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<IClassIdGenerator> getGeneratorsOrdered() {
        if (allGeneratorsOrdered == null) {
            Object object = LOCK;
            synchronized (object) {
                if (allGeneratorsOrdered == null) {
                    IExtension[] extensions;
                    TreeMap<CompositeObject, IClassIdGenerator> tmp = new TreeMap<CompositeObject, IClassIdGenerator>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.s2e", EXTENSION_POINT_NAME);
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if (TAG_NAME.equals(element.getName())) {
                                try {
                                    IClassIdGenerator generator = (IClassIdGenerator)element.createExecutableExtension(ATTRIB_CLASS);
                                    String prio = element.getAttribute(ATTRIB_PRIO);
                                    Double priority = null;
                                    if (!StringUtils.isBlank((CharSequence)prio)) {
                                        priority = ClassIdGenerators.parseDouble(prio);
                                    } else {
                                        SdkLog.warning((String)"No priority found for extension '{}'. Using 0.0", (Object[])new Object[]{element.getNamespaceIdentifier()});
                                        priority = 0.0;
                                    }
                                    tmp.put(new CompositeObject(new Object[]{-priority.doubleValue(), generator.getClass().getName(), generator}), generator);
                                }
                                catch (Exception e) {
                                    SdkLog.warning((String)"Could not load classIdGenerator extension '{}'.", (Object[])new Object[]{element.getNamespaceIdentifier(), e});
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    allGeneratorsOrdered = tmp.values();
                }
            }
        }
        return allGeneratorsOrdered;
    }

    private static Double parseDouble(String order) {
        try {
            return Double.parseDouble(order);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String generateNewId(ClassIdGenerationContext context) {
        for (IClassIdGenerator gen : ClassIdGenerators.getGeneratorsOrdered()) {
            String newId = gen.generate(context);
            if (newId == null) continue;
            return newId;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAutomaticallyCreateClassIdAnnotation() {
        Object object = LOCK;
        synchronized (object) {
            return automaticallyCreateClassIdAnnotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAutomaticallyCreateClassIdAnnotation(boolean newValue) {
        Object object = LOCK;
        synchronized (object) {
            automaticallyCreateClassIdAnnotation = newValue;
        }
    }
}

