/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.form;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.s.sourcebuilder.form.FormSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.permission.PermissionSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class FormNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider = new CachingJavaEnvironmentProvider();
    private static final String TEXT_AUTHORIZATION_FAILED = "AuthorizationFailed";
    private String m_formName;
    private IPackageFragmentRoot m_clientSourceFolder;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private IPackageFragmentRoot m_formDataSourceFolder;
    private String m_clientPackage;
    private IType m_superType;
    private boolean m_createFormData;
    private boolean m_createService;
    private boolean m_createPermissions;
    private IType m_createdForm;
    private IType m_createdFormData;
    private IType m_createdServiceInterface;
    private IType m_createdServiceImpl;
    private IType m_createdReadPermission;
    private IType m_createdUpdatePermission;

    @Override
    public String getOperationName() {
        return "Create Form '" + this.getFormName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getFormName()), (String)"No form name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getClientSourceFolder()), (String)"No client source folder provided", (Object[])new Object[0]);
        if (this.isCreateService()) {
            Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getServerSourceFolder()), (String)"No server source folder provided", (Object[])new Object[0]);
        }
        if (this.isCreateService() || this.isCreateFormData() || this.isCreatePermissions()) {
            Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No shared source folder provided", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"Super type does not exist", (Object[])new Object[0]);
    }

    protected int getTotalWork() {
        int result = 1;
        if (this.isCreateFormData()) {
            ++result;
        }
        if (this.isCreateService()) {
            result += 2;
        }
        if (this.isCreatePermissions()) {
            result += 2;
        }
        return result;
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)this.getTotalWork());
        String sharedPackage = ScoutTier.Client.convert(ScoutTier.Shared, this.getClientPackage());
        String baseName = this.getFormName();
        if (baseName.endsWith("Form")) {
            baseName = baseName.substring(0, baseName.length() - "Form".length());
        }
        if (this.isCreateFormData()) {
            this.setCreatedFormData(this.createFormData(sharedPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        if (this.isCreatePermissions()) {
            String permissionBaseName = String.valueOf(baseName) + "Permission";
            this.setCreatedReadPermission(this.createReadPermission(permissionBaseName, sharedPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
            this.setCreatedUpdatePermission(this.createUpdatePermission(permissionBaseName, sharedPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        if (this.isCreateService()) {
            this.createService(sharedPackage, baseName, (IProgressMonitor)progress.newChild(2), workingCopyManager);
        }
        this.setCreatedForm(this.createForm((IProgressMonitor)progress.newChild(1), workingCopyManager));
        if (this.isCreateFormData()) {
            ScoutSdkCore.getDerivedResourceManager().trigger(Collections.singleton(this.getCreatedForm().getResource()));
        }
    }

    protected void createService(String sharedPackage, String baseName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ServiceNewOperation serviceNewOperation = this.createServiceOperation();
        serviceNewOperation.setServiceName(baseName);
        serviceNewOperation.setSharedPackage(sharedPackage);
        serviceNewOperation.setSharedSourceFolder(this.getSharedSourceFolder());
        serviceNewOperation.setServerSourceFolder(this.getServerSourceFolder());
        serviceNewOperation.addMethod(this.createServiceMethod("load"));
        serviceNewOperation.addMethod(this.createServiceMethod("store"));
        serviceNewOperation.validate();
        serviceNewOperation.run(monitor, workingCopyManager);
        this.setCreatedServiceImpl(serviceNewOperation.getCreatedServiceImpl());
        this.setCreatedServiceInterface(serviceNewOperation.getCreatedServiceInterface());
    }

    protected IMethodSourceBuilder createServiceMethod(String name) {
        MethodSourceBuilder methodBuilder = new MethodSourceBuilder(name);
        methodBuilder.setFlags(1);
        methodBuilder.setComment(CommentSourceBuilderFactory.createDefaultMethodComment((IMethodSourceBuilder)methodBuilder));
        if (this.isCreateFormData()) {
            String formDataSig = Signature.createTypeSignature((String)this.getCreatedFormData().getFullyQualifiedName());
            methodBuilder.setReturnTypeSignature(formDataSig);
            methodBuilder.addParameter((IMethodParameterSourceBuilder)new MethodParameterSourceBuilder("input", formDataSig));
        } else {
            methodBuilder.setReturnTypeSignature("V");
        }
        methodBuilder.setBody(new ISourceBuilder((IMethodSourceBuilder)methodBuilder){
            private final /* synthetic */ IMethodSourceBuilder val$methodBuilder;
            {
                this.val$methodBuilder = iMethodSourceBuilder;
            }

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String permissionSig = null;
                if (FormNewOperation.this.isCreatePermissions() && "load".equals(this.val$methodBuilder.getElementName())) {
                    permissionSig = Signature.createTypeSignature((String)FormNewOperation.this.getCreatedReadPermission().getFullyQualifiedName());
                } else if (FormNewOperation.this.isCreatePermissions() && "store".equals(this.val$methodBuilder.getElementName())) {
                    permissionSig = Signature.createTypeSignature((String)FormNewOperation.this.getCreatedUpdatePermission().getFullyQualifiedName());
                }
                if (permissionSig != null) {
                    FormNewOperation.this.createPermissionCheckSource(source, lineDelimiter, validator, permissionSig);
                }
                FormNewOperation.this.createMethodContentSource(source, lineDelimiter, validator, this.val$methodBuilder);
            }
        });
        return methodBuilder;
    }

    protected void createPermissionCheckSource(StringBuilder source, String lineDelimiter, IImportValidator validator, String permissionSig) {
        source.append("if(!").append(validator.useName("org.eclipse.scout.rt.shared.services.common.security.ACCESS"));
        source.append(".check(new ").append(validator.useSignature(permissionSig)).append("())) {").append(lineDelimiter);
        source.append("  throw new ").append(validator.useName("org.eclipse.scout.rt.platform.exception.VetoException")).append('(');
        source.append(validator.useName("org.eclipse.scout.rt.shared.TEXTS"));
        source.append(".get(\"").append(TEXT_AUTHORIZATION_FAILED).append("\")");
        source.append(");").append(lineDelimiter);
        source.append('}').append(lineDelimiter);
    }

    protected void createMethodContentSource(StringBuilder source, String lineDelimiter, IImportValidator validator, IMethodSourceBuilder parentMethod) {
        source.append(CoreUtils.getCommentBlock((String)"add business logic here.")).append(lineDelimiter);
        String paramToReturn = this.getParamNameOfReturnType(parentMethod);
        String returnSig = parentMethod.getReturnTypeSignature();
        if (paramToReturn == null) {
            String returnValue = CoreUtils.getDefaultValueOf((String)returnSig);
            if (returnValue != null) {
                source.append("return ").append(returnValue).append(';');
            }
        } else {
            source.append("return ").append(paramToReturn).append(';');
        }
    }

    protected String getParamNameOfReturnType(IMethodSourceBuilder msb) {
        if (msb.getReturnTypeSignature() == null || "V".equals(msb.getReturnTypeSignature())) {
            return null;
        }
        for (IMethodParameterSourceBuilder mpsb : msb.getParameters()) {
            if (!msb.getReturnTypeSignature().equals(mpsb.getDataTypeSignature())) continue;
            return mpsb.getElementName();
        }
        return null;
    }

    protected ServiceNewOperation createServiceOperation() {
        return new ServiceNewOperation(this.getEnvProvider());
    }

    protected IType createFormData(String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String formDataName = String.valueOf(this.getFormName()) + "Data";
        CompilationUnitSourceBuilder formDataBuilder = new CompilationUnitSourceBuilder(String.valueOf(formDataName) + ".java", sharedPackage);
        TypeSourceBuilder formDataTypeBuilder = new TypeSourceBuilder(formDataName);
        formDataTypeBuilder.setFlags(1);
        formDataTypeBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData"));
        formDataBuilder.addType((ITypeSourceBuilder)formDataTypeBuilder);
        return S2eUtils.writeType(this.getFormDataSourceFolder(), (ICompilationUnitSourceBuilder)formDataBuilder, this.getEnvProvider().get(this.getFormDataSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createReadPermission(String permissionBaseName, String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        PermissionSourceBuilder psb = new PermissionSourceBuilder("Read" + permissionBaseName, sharedPackage);
        psb.setup();
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)psb, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createUpdatePermission(String permissionBaseName, String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        PermissionSourceBuilder psb = new PermissionSourceBuilder("Update" + permissionBaseName, sharedPackage);
        psb.setup();
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)psb, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createForm(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        FormSourceBuilder formBuilder = this.createFormBuilder();
        return S2eUtils.writeType(this.getClientSourceFolder(), (ICompilationUnitSourceBuilder)formBuilder, this.getEnvProvider().get(this.getClientSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected FormSourceBuilder createFormBuilderInstance() {
        return new FormSourceBuilder(this.getFormName(), this.getClientPackage());
    }

    protected FormSourceBuilder createFormBuilder() {
        FormSourceBuilder formBuilder = this.createFormBuilderInstance();
        formBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        if (this.isCreateFormData()) {
            formBuilder.setFormDataSignature(Signature.createTypeSignature((String)this.getCreatedFormData().getFullyQualifiedName()));
        }
        if (this.isCreateService()) {
            formBuilder.setServiceIfcSignature(Signature.createTypeSignature((String)this.getCreatedServiceInterface().getFullyQualifiedName()));
        }
        if (this.isCreatePermissions()) {
            formBuilder.setUpdatePermissionSignature(Signature.createTypeSignature((String)this.getCreatedUpdatePermission().getFullyQualifiedName()));
        }
        if (ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation()) {
            String[] classIds = new String[4];
            ClassIdGenerationContext context = new ClassIdGenerationContext(String.valueOf(this.getClientPackage()) + '.' + this.getFormName());
            int i = 0;
            while (i < classIds.length) {
                classIds[i] = ClassIdGenerators.generateNewId(context);
                ++i;
            }
            formBuilder.setClassIdValues(classIds);
        }
        formBuilder.setup();
        return formBuilder;
    }

    public String getFormName() {
        return this.m_formName;
    }

    public void setFormName(String formName) {
        this.m_formName = formName;
    }

    public IPackageFragmentRoot getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IPackageFragmentRoot clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public String getClientPackage() {
        return this.m_clientPackage;
    }

    public void setClientPackage(String clientPackage) {
        this.m_clientPackage = clientPackage;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public boolean isCreateFormData() {
        return this.m_createFormData;
    }

    public void setCreateFormData(boolean createFormData) {
        this.m_createFormData = createFormData;
    }

    public boolean isCreateService() {
        return this.m_createService;
    }

    public void setCreateService(boolean createService) {
        this.m_createService = createService;
    }

    public boolean isCreatePermissions() {
        return this.m_createPermissions;
    }

    public void setCreatePermissions(boolean createPermissions) {
        this.m_createPermissions = createPermissions;
    }

    public IType getCreatedForm() {
        return this.m_createdForm;
    }

    protected void setCreatedForm(IType createdForm) {
        this.m_createdForm = createdForm;
    }

    public IType getCreatedFormData() {
        return this.m_createdFormData;
    }

    protected void setCreatedFormData(IType createdFormData) {
        this.m_createdFormData = createdFormData;
    }

    public IType getCreatedServiceInterface() {
        return this.m_createdServiceInterface;
    }

    protected void setCreatedServiceInterface(IType createdServiceInterface) {
        this.m_createdServiceInterface = createdServiceInterface;
    }

    public IType getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IType createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public IType getCreatedReadPermission() {
        return this.m_createdReadPermission;
    }

    protected void setCreatedReadPermission(IType createdReadPermission) {
        this.m_createdReadPermission = createdReadPermission;
    }

    public IType getCreatedUpdatePermission() {
        return this.m_createdUpdatePermission;
    }

    protected void setCreatedUpdatePermission(IType createdUpdatePermission) {
        this.m_createdUpdatePermission = createdUpdatePermission;
    }

    public IPackageFragmentRoot getFormDataSourceFolder() {
        return this.m_formDataSourceFolder;
    }

    public void setFormDataSourceFolder(IPackageFragmentRoot formDataSourceFolder) {
        this.m_formDataSourceFolder = formDataSourceFolder;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }
}

