/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.lookupcall;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.s.sourcebuilder.lookupcall.LookupCallSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class LookupCallNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider = new CachingJavaEnvironmentProvider();
    private String m_lookupCallName;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private String m_package;
    private IType m_superType;
    private IType m_keyType;
    private IType m_lookupServiceSuperType;
    private IType m_createdLookupCall;
    private IType m_createdLookupServiceIfc;
    private IType m_createdLookupServiceImpl;

    @Override
    public String getOperationName() {
        return "Create LookupCall '" + this.getLookupCallName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getLookupCallName()), (String)"No lookup call name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No shared source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getKeyType()), (String)"No key type provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"No supertype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        String suffix;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)3);
        String svcName = this.getLookupCallName();
        if (svcName.endsWith(suffix = "Call")) {
            svcName = svcName.substring(0, svcName.length() - suffix.length());
        }
        svcName = String.valueOf(svcName) + "Service";
        this.setCreatedLookupServiceIfc(this.createLookupServiceIfc(svcName, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        if (S2eUtils.exists((IJavaElement)this.getServerSourceFolder()) && S2eUtils.exists((IJavaElement)this.getLookupServiceSuperType())) {
            String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, this.getPackage());
            this.setCreatedLookupServiceImpl(this.createLookupServiceImpl(svcName, serverPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        progress.setWorkRemaining(1);
        this.setCreatedLookupCall(this.createLookupCall((IProgressMonitor)progress.newChild(1), workingCopyManager));
    }

    protected IType createLookupServiceIfc(String svcName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String ifcName = String.valueOf('I') + svcName;
        CompilationUnitSourceBuilder ifcBuilder = new CompilationUnitSourceBuilder(String.valueOf(ifcName) + ".java", this.getPackage());
        ifcBuilder.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)ifcBuilder));
        TypeSourceBuilder lookupSvcIfcBuilder = new TypeSourceBuilder(ifcName);
        lookupSvcIfcBuilder.setFlags(513);
        lookupSvcIfcBuilder.setComment(CommentSourceBuilderFactory.createDefaultTypeComment((ITypeSourceBuilder)lookupSvcIfcBuilder));
        StringBuilder superTypeBuilder = new StringBuilder("org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType().getFullyQualifiedName());
        superTypeBuilder.append('>');
        lookupSvcIfcBuilder.addInterfaceSignature(Signature.createTypeSignature((String)superTypeBuilder.toString()));
        ifcBuilder.addType((ITypeSourceBuilder)lookupSvcIfcBuilder);
        lookupSvcIfcBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createTunnelToServer());
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)ifcBuilder, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createLookupServiceImpl(String svcName, String serverPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String icuFileName = String.valueOf(svcName) + ".java";
        CompilationUnitSourceBuilder implBuilder = new CompilationUnitSourceBuilder(icuFileName, serverPackage);
        TypeSourceBuilder lookupSvcImplBuilder = new TypeSourceBuilder(svcName);
        lookupSvcImplBuilder.setFlags(1);
        StringBuilder superTypeBuilder = new StringBuilder(this.getLookupServiceSuperType().getFullyQualifiedName());
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType().getFullyQualifiedName());
        superTypeBuilder.append('>');
        lookupSvcImplBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)superTypeBuilder.toString()));
        lookupSvcImplBuilder.addInterfaceSignature(Signature.createTypeSignature((String)this.getCreatedLookupServiceIfc().getFullyQualifiedName()));
        implBuilder.addType((ITypeSourceBuilder)lookupSvcImplBuilder);
        IJavaEnvironment env = ScoutSdkCore.createJavaEnvironment(this.getServerSourceFolder().getJavaProject());
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((String)lookupSvcImplBuilder.getSuperTypeSignature(), null, (IJavaEnvironment)env);
        for (IMethodSourceBuilder methodSourceBuilder : unimplementedMethods) {
            lookupSvcImplBuilder.addMethod(methodSourceBuilder);
        }
        return S2eUtils.writeType(this.getServerSourceFolder(), (ICompilationUnitSourceBuilder)implBuilder, this.getEnvProvider().get(this.getServerSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createLookupCall(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        LookupCallSourceBuilder lcsb = new LookupCallSourceBuilder(this.getLookupCallName(), this.getPackage());
        lcsb.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        if (S2eUtils.exists((IJavaElement)this.getCreatedLookupServiceIfc())) {
            lcsb.setLookupServiceIfcSignature(Signature.createTypeSignature((String)this.getCreatedLookupServiceIfc().getFullyQualifiedName()));
        }
        lcsb.setKeyTypeSignature(Signature.createTypeSignature((String)this.getKeyType().getFullyQualifiedName()));
        lcsb.setup();
        IJavaEnvironment env = ScoutSdkCore.createJavaEnvironment(this.getSharedSourceFolder().getJavaProject());
        List unimplementedMethods = MethodSourceBuilderFactory.createUnimplementedMethods((String)lcsb.getMainType().getSuperTypeSignature(), null, (IJavaEnvironment)env);
        for (IMethodSourceBuilder methodSourceBuilder : unimplementedMethods) {
            lcsb.getMainType().addSortedMethod(SortedMemberKeyFactory.createMethodAnyKey((IMethodSourceBuilder)methodSourceBuilder), methodSourceBuilder);
        }
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)lcsb, this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    public IType getCreatedLookupCall() {
        return this.m_createdLookupCall;
    }

    protected void setCreatedLookupCall(IType createdLookupCall) {
        this.m_createdLookupCall = createdLookupCall;
    }

    public String getLookupCallName() {
        return this.m_lookupCallName;
    }

    public void setLookupCallName(String lookupCallName) {
        this.m_lookupCallName = lookupCallName;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getKeyType() {
        return this.m_keyType;
    }

    public void setKeyType(IType keyType) {
        this.m_keyType = keyType;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IType getCreatedLookupServiceIfc() {
        return this.m_createdLookupServiceIfc;
    }

    protected void setCreatedLookupServiceIfc(IType createdLookupServiceIfc) {
        this.m_createdLookupServiceIfc = createdLookupServiceIfc;
    }

    public IType getCreatedLookupServiceImpl() {
        return this.m_createdLookupServiceImpl;
    }

    protected void setCreatedLookupServiceImpl(IType createdLookupServiceImpl) {
        this.m_createdLookupServiceImpl = createdLookupServiceImpl;
    }

    public IType getLookupServiceSuperType() {
        return this.m_lookupServiceSuperType;
    }

    public void setLookupServiceSuperType(IType lookupServiceSuperType) {
        this.m_lookupServiceSuperType = lookupServiceSuperType;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }
}

